/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos;

import java.io.Serializable;
import java.util.ArrayList;
import org.jini.rio.core.MeasuredResource;
import org.jini.rio.qos.capability.PlatformCapability;

public class ResourceCapability
implements Comparable,
Serializable {
    static final long serialVersionUID = 1L;
    private PlatformCapability[] platformCapabilities;
    private MeasuredResource[] measuredResources;
    private final String address;
    private final String hostName;
    private final String[] zones;
    private final long processId;
    private boolean persistentProvisioning;
    public static final int ALL_MEASURED_RESOURCES = 1;
    public static final int MEASURED_RESOURCES_BREACHED = 2;

    public ResourceCapability(String address, String hostName, String[] zones, long processId, boolean persistentProvisioning, PlatformCapability[] platformCapabilities, MeasuredResource[] measuredResources) {
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        if (hostName == null) {
            throw new NullPointerException("hostName is null");
        }
        if (platformCapabilities == null) {
            throw new NullPointerException("platformCapabilities is null");
        }
        if (measuredResources == null) {
            throw new NullPointerException("measuredResources is null");
        }
        this.address = address;
        this.hostName = hostName;
        this.zones = zones;
        this.processId = processId;
        this.persistentProvisioning = persistentProvisioning;
        this.platformCapabilities = platformCapabilities;
        this.measuredResources = measuredResources;
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String[] getZones() {
        return this.zones;
    }

    public long getProcessId() {
        return this.processId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getUtilization() {
        double utilization = 0.0;
        ResourceCapability resourceCapability = this;
        synchronized (resourceCapability) {
            for (int i = 0; i < this.measuredResources.length; ++i) {
                utilization += this.measuredResources[i].getValue();
            }
        }
        return utilization /= (double)this.measuredResources.length;
    }

    public boolean supportsPersistentProvisioning() {
        return this.persistentProvisioning;
    }

    public PlatformCapability[] getPlatformCapabilities() {
        if (this.platformCapabilities == null) {
            return new PlatformCapability[0];
        }
        PlatformCapability[] pCaps = new PlatformCapability[this.platformCapabilities.length];
        System.arraycopy(this.platformCapabilities, 0, pCaps, 0, this.platformCapabilities.length);
        return pCaps;
    }

    public MeasuredResource[] getMeasuredResources() {
        return this.getMeasuredResources(1);
    }

    public MeasuredResource[] getMeasuredResources(int type) {
        if (type < 1 || type > 2) {
            throw new IllegalArgumentException("unknown type : " + type);
        }
        MeasuredResource[] mRes = null;
        if (type == 1) {
            mRes = new MeasuredResource[this.measuredResources.length];
            System.arraycopy(this.measuredResources, 0, mRes, 0, this.measuredResources.length);
        } else {
            ArrayList<MeasuredResource> list = new ArrayList<MeasuredResource>();
            for (int i = 0; i < this.measuredResources.length; ++i) {
                if (!this.measuredResources[i].thresholdCrossed()) continue;
                list.add(this.measuredResources[i]);
            }
            mRes = list.toArray(new MeasuredResource[list.size()]);
        }
        return mRes;
    }

    public boolean measuredResourcesWithinRange() {
        for (int i = 0; i < this.measuredResources.length; ++i) {
            if (!this.measuredResources[i].thresholdCrossed()) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        ResourceCapability that = (ResourceCapability)o;
        if (this.getUtilization() < that.getUtilization()) {
            return -1;
        }
        if (this.getUtilization() > that.getUtilization()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < this.measuredResources.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.measuredResources[i].getIdentifier() + "=" + this.measuredResources[i].getValue());
        }
        for (i = 0; i < this.platformCapabilities.length; ++i) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.platformCapabilities[i].toString());
        }
        return this.hostName + "@" + this.address + "[" + this.processId + "] Utilization=" + this.getUtilization() + ", " + buffer.toString();
    }
}

