/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos;

import com.gigaspaces.start.SystemInfo;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.AggregateConfig;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.EmptyConfiguration;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.event.EventHandler;
import org.jini.rio.jsb.JSBContext;
import org.jini.rio.qos.SLAPolicyEvent;
import org.jini.rio.qos.SLAPolicyEventListener;
import org.jini.rio.qos.SLAThresholdEvent;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.ThresholdListener;
import org.jini.rio.watch.ThresholdManager;

public class SLAPolicyHandler
implements ThresholdListener {
    private SLA mySLA;
    protected Object proxy;
    protected Object eventSource;
    protected ServiceBeanContext context;
    private EventHandler eventHandler;
    protected ThresholdManager thresholdManager;
    protected boolean initialized = false;
    private Vector listeners = new Vector();
    private static final String description = "Default Policy Handler";
    private String hostAddress;
    private boolean sendRemoteNotifications = true;
    static Logger logger = Logger.getLogger("org.jini.rio.qos");

    public SLAPolicyHandler(SLA sla) {
        if (sla == null) {
            throw new NullPointerException("sla is null");
        }
        this.mySLA = sla;
        this.hostAddress = SystemInfo.singleton().network().getHost().getHostAddress();
    }

    public void initialize(Object proxy, Object eventSource, EventHandler eventHandler, ServiceBeanContext context) {
        if (this.initialized) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[" + this.getID() + "] " + this.getClass().getName() + "already initialized");
            }
            return;
        }
        if (proxy == null) {
            throw new NullPointerException("proxy is null");
        }
        if (eventSource == null) {
            throw new NullPointerException("source is null");
        }
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler is null");
        }
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        this.proxy = proxy;
        this.eventSource = eventSource;
        this.eventHandler = eventHandler;
        this.context = context;
        this.initialized = true;
    }

    protected Object getEventSource() {
        return this.eventSource;
    }

    protected Object getProxy() {
        return this.proxy;
    }

    public String getDescription() {
        return description;
    }

    public void updateSLA(SLA sla) {
        if (sla == null) {
            throw new NullPointerException("sla is null");
        }
        this.mySLA = sla;
        if (this.thresholdManager != null) {
            this.thresholdManager.setThresholdValues(this.mySLA);
        }
    }

    public SLA getSLA() {
        return this.mySLA;
    }

    public Configuration getConfiguration() throws ConfigurationException {
        String[] configArgs;
        Object config = null;
        Configuration sharedConfig = null;
        if (this.context != null && this.context instanceof JSBContext) {
            sharedConfig = ((JSBContext)this.context).getSharedConfiguration();
        }
        if ((configArgs = this.mySLA.getConfigArgs()) == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Unknown configArgs, for [" + this.mySLA.getIdentifier() + "] SLA, create EmptyConfiguration");
            }
            config = sharedConfig != null ? new AggregateConfig(sharedConfig, new String[]{"-"}) : EmptyConfiguration.INSTANCE;
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                String type = sharedConfig == null ? "Standalone" : "Aggregate";
                logger.finest("Create " + type + " Configuration for [" + this.mySLA.getIdentifier() + "] SLA");
            }
            config = sharedConfig != null ? new AggregateConfig(sharedConfig, configArgs) : ConfigurationProvider.getInstance((String[])configArgs, null);
        }
        return config;
    }

    @Override
    public String getID() {
        return this.mySLA.getIdentifier();
    }

    @Override
    public void setThresholdManager(ThresholdManager thresholdManager) {
        if (thresholdManager == null) {
            throw new NullPointerException("thresholdManager is null");
        }
        this.thresholdManager = thresholdManager;
        this.thresholdManager.addThresholdListener(this);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getClass().getName() + " [" + this.getID() + "]: setThresholdManager() " + this.mySLA.toString());
        }
    }

    public ThresholdManager getThresholdManager() {
        return this.thresholdManager;
    }

    public void disconnect() {
        if (this.thresholdManager != null) {
            this.thresholdManager.removeThresholdListener(this);
        }
    }

    @Override
    public void notify(Calculable calculable, ThresholdValues thresholdValues, int type) {
        if (logger.isLoggable(Level.FINE)) {
            String status = type == 0 ? "breached" : "cleared";
            logger.fine("SLAPolicyHandler.notify() : " + calculable.getId() + ", type=" + status + " Value=" + calculable.getValue() + ", High=" + this.mySLA.getCurrentHighThreshold() + ", Low=" + this.mySLA.getCurrentLowThreshold());
        }
        if (this.eventHandler != null) {
            this.sendSLAThresholdEvent(calculable, thresholdValues, type);
        } else {
            logger.warning("Unable to send SLAThresholdEvent, eventHandler is null");
        }
    }

    public void registerListener(SLAPolicyEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void unregisterListener(SLAPolicyEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listeners.removeElement(listener);
    }

    public void setSendRemoteNotification(boolean sendRemoteNotifications) {
        this.sendRemoteNotifications = sendRemoteNotifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(SLAPolicyEvent event) {
        Object[] arrLocal;
        SLAPolicyHandler sLAPolicyHandler = this;
        synchronized (sLAPolicyHandler) {
            arrLocal = this.listeners.toArray();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ((SLAPolicyEventListener)arrLocal[i]).policyAction(event);
        }
    }

    protected void sendSLAThresholdEvent(Calculable calculable, ThresholdValues tValues, int type) {
        try {
            double[] range = new double[]{tValues.getCurrentLowThreshold(), tValues.getCurrentHighThreshold()};
            SLA sla = new SLA(this.mySLA.getIdentifier(), range);
            SLAThresholdEvent event = new SLAThresholdEvent(this.eventSource, this.context.getServiceElement(), this.context.getServiceBeanManager().getServiceBeanInstance(), calculable, sla, this.getDescription(), this.hostAddress, type);
            String sType = type == 0 ? "BREACHED" : "CLEARED";
            SLAPolicyEvent localEvent = new SLAPolicyEvent(this, sla, "THRESHOLD_" + sType);
            localEvent.setSLAThresholdEvent(event);
            this.notifyListeners(localEvent);
            if (this.sendRemoteNotifications) {
                new Thread(new SLAThresholdEventTask(event)).start();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Creating a SLAThresholdEvent", e);
        }
    }

    class SLAThresholdEventTask
    implements Runnable {
        SLAThresholdEvent event;

        SLAThresholdEventTask(SLAThresholdEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                SLAPolicyHandler.this.eventHandler.fire(this.event);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Notifying SLAThresholdEvent consumers", e);
            }
        }
    }
}

