/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos;

import com.sun.jini.config.Config;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.EmptyConfiguration;
import org.jini.rio.core.SLA;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.event.EventHandler;
import org.jini.rio.qos.SLAPolicyHandler;

public class SLAPolicyHandlerFactory {
    private static final String COMPONENT = "org.jini.rio.qos";
    private static Logger logger = Logger.getLogger("org.jini.rio.qos");

    public static SLAPolicyHandler create(SLA sla, Object proxy, Object eventSource, EventHandler eventHandler, ServiceBeanContext context, ClassLoader loader) throws ConfigurationException {
        if (sla == null) {
            throw new NullPointerException("sla is null");
        }
        EmptyConfiguration config = null;
        String[] configArgs = sla.getConfigArgs();
        if (configArgs == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unknown configArgs, create EmptyConfiguration");
            }
            config = EmptyConfiguration.INSTANCE;
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Create Configuration");
            }
            config = ConfigurationProvider.getInstance((String[])configArgs, (ClassLoader)loader);
        }
        SLAPolicyHandler slaPolicyHandler = (SLAPolicyHandler)Config.getNonNullEntry((Configuration)config, (String)"org.jini.rio.qos.SLAPolicyHandler", (String)"slaPolicyHandler", SLAPolicyHandler.class, (Object)new SLAPolicyHandler(sla), (Object)sla);
        slaPolicyHandler.initialize(proxy, eventSource, eventHandler, context);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SLAPolicyHandler [" + slaPolicyHandler.getClass().getName() + "] created");
        }
        return slaPolicyHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean slaPolicyHandlerChanged(SLA sla, SLAPolicyHandler handler) {
        boolean changed;
        block5: {
            String currentHandler;
            String[] configArgs;
            block6: {
                changed = false;
                if (sla.getConfigArgs() == null || (configArgs = sla.getConfigArgs()).length <= 0) break block5;
                currentHandler = handler.getClass().getName();
                if (configArgs[0].equals("-")) break block6;
                try {
                    Configuration config = ConfigurationProvider.getInstance((String[])configArgs);
                    SLAPolicyHandler slaPolicyHandler = (SLAPolicyHandler)config.getEntry("org.jini.rio.qos.SLAPolicyHandler", "slaPolicyHandler", SLAPolicyHandler.class, Configuration.NO_DEFAULT, (Object)sla);
                    if (!slaPolicyHandler.getClass().getName().equals(currentHandler)) {
                        changed = true;
                    }
                    break block5;
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINEST)) break block5;
                    logger.log(Level.FINEST, "Getting Configuration for SLAPolicyHandler", e);
                }
                break block5;
            }
            for (int i = 1; i < configArgs.length; ++i) {
                String result;
                if (!configArgs[i].startsWith("org.jini.rio.qos.SLAPolicyHandler.slaPolicyHandler")) continue;
                int ndx = configArgs[i].indexOf("=");
                if (ndx == -1 || (ndx = (result = configArgs[i].substring(ndx)).indexOf(currentHandler)) != -1) break;
                changed = true;
                break;
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "SLAPolicyHandler for SLA [" + sla.getIdentifier() + "] has changed [" + changed + "]");
        }
        return changed;
    }
}

