/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos;

import java.rmi.RemoteException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.UnknownEventException;
import org.jini.rio.event.EventNotificationAdapter;
import org.jini.rio.qos.SLAPolicyEvent;
import org.jini.rio.qos.SLAPolicyEventListener;
import org.jini.rio.qos.SLAThresholdEvent;

public class SLAThresholdEventAdapter
extends EventNotificationAdapter
implements SLAPolicyEventListener {
    public static final String EVENT_TYPE_BREACHED = "sla.SLAThresholdEvent.breached";
    public static final String EVENT_TYPE_CLEARED = "sla.SLAThresholdEvent.cleared";
    protected static final MBeanNotificationInfo NOTIFICATION_INFO = new MBeanNotificationInfo(new String[]{"sla.SLAThresholdEvent.breached", "sla.SLAThresholdEvent.cleared"}, Notification.class.getName(), "SLAThresholdEvent");

    public SLAThresholdEventAdapter(ObjectName objectName, NotificationBroadcasterSupport notificationBroadcasterSupport) {
        super(objectName, notificationBroadcasterSupport);
    }

    @Override
    public void notify(RemoteEvent theEvent) throws UnknownEventException, RemoteException {
        if (theEvent == null) {
            throw new NullPointerException("event is null");
        }
        if (!(theEvent instanceof SLAThresholdEvent)) {
            throw new UnknownEventException("Not a SLAThresholdEvent [" + theEvent.getClass().getName() + "]");
        }
        this.buildAndSend((SLAThresholdEvent)theEvent);
    }

    @Override
    public void policyAction(SLAPolicyEvent event) {
        if (event == null) {
            throw new NullPointerException("event is null");
        }
        SLAThresholdEvent slaThresholdEvent = event.getSLAThresholdEvent();
        if (slaThresholdEvent != null) {
            this.buildAndSend(slaThresholdEvent);
        }
    }

    @Override
    public MBeanNotificationInfo getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    private void buildAndSend(SLAThresholdEvent event) {
        String type = null;
        if (event.getType() == 0) {
            type = EVENT_TYPE_BREACHED;
        } else if (event.getType() == 1) {
            type = EVENT_TYPE_CLEARED;
        }
        Notification notification = new Notification(type, this.objectName, event.getSequenceNumber(), event.getTime().getTime(), this.getMessage(event));
        this.notificationBroadcasterSupport.sendNotification(notification);
    }

    private String getMessage(SLAThresholdEvent event) {
        return event.getServiceElement().getName() + "." + event.getServiceElement().getOperationalStringName() + " SLA [" + event.getSLA().getIdentifier() + "] " + (event.getType() == 0 ? "BREACHED" : "CLEARED") + " low=" + event.getSLA().getCurrentLowThreshold() + ", high=" + event.getSLA().getCurrentHighThreshold();
    }
}

