/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos;

import com.sun.jini.config.Config;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.export.Exporter;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.jsb.ServiceElementChangeListener;
import org.jini.rio.event.EventHandler;
import org.jini.rio.qos.SLAPolicyEvent;
import org.jini.rio.qos.SLAPolicyHandler;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.ThresholdManager;

public class ScalingPolicyHandler
extends SLAPolicyHandler
implements ServiceProvisionListener,
ServerProxyTrust {
    private static final String description = "Scaling Policy Handler";
    public static final String MAX_SERVICES = "MaxServices";
    public static final String MIN_SERVICES = "MinServices";
    public static final String DESTROY_DECREMENT = "DestroyOnDecrement";
    public static final String SEND_NOTIFICATION = "SendRemoteNotification";
    public static final String UPPER_DAMPER = "UpperThresholdDampeningFactor";
    public static final String LOWER_DAMPER = "LowerThresholdDampeningFactor";
    public static final String INCREMENT_PENDING = "INCREMENT_PENDING";
    public static final String INCREMENT_FAILURE = "INCREMENT_FAILURE";
    public static final String INCREMENT_SUCCEEDED = "INCREMENT_SUCCEEDED";
    public static final String DECREMENT_SENT = "DECREMENT_SENT";
    public static final String DECREMENT_DESTROY_SENT = "DECREMENT_DESTROY_SENT";
    public static final String DECREMENT_FAILED = "DECREMENT_FAILED";
    private int totalServices;
    private boolean destroyOnDecrement = true;
    private boolean haveDecremented = false;
    public static final int UNDEFINED = -1;
    private int maxServices = -1;
    private int minServices = 1;
    private ServiceElement sElem;
    private long upperThresholdDampeningTime;
    private long lowerThresholdDampeningTime;
    private Timer taskTimer;
    private ScalingTask incrementTask;
    private ScalingTask decrementTask;
    private Object ourRemoteRef;
    private Exporter exporter;
    private ServiceElementChangeManager svcElementListener;
    private int pendingRequests;
    private boolean connected;
    private static final String COMPONENT = "org.jini.rio.qos.ScalingPolicyHandler";
    static Logger logger = Logger.getLogger("org.jini.rio.qos.ScalingPolicyHandler");

    public ScalingPolicyHandler(SLA sla) {
        super(sla);
        try {
            this.exporter = ExporterConfig.getExporter(this.getConfiguration(), COMPONENT, "provisionListenerExporter");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Getting provisionListenerExporter", e);
        }
        this.taskTimer = new Timer(true);
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setThresholdManager(ThresholdManager thresholdManager) {
        if (this.ourRemoteRef == null) {
            this.exportDo();
        }
        super.setThresholdManager(thresholdManager);
    }

    @Override
    public void disconnect() {
        if (this.svcElementListener != null && this.context != null) {
            this.context.getServiceBeanManager().removeListener(this.svcElementListener);
        }
        try {
            this.exporter.unexport(true);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.taskTimer != null) {
            this.taskTimer.cancel();
        }
        this.connected = false;
        super.disconnect();
    }

    @Override
    public void updateSLA(SLA sla) {
        super.updateSLA(sla);
        this.initProperties(true);
    }

    @Override
    public void initialize(Object proxy, Object eventSource, EventHandler eventHandler, ServiceBeanContext context) {
        super.initialize(proxy, eventSource, eventHandler, context);
        boolean update = this.context == null;
        this.context = context;
        this.sElem = context.getServiceElement();
        if (this.svcElementListener == null) {
            this.svcElementListener = new ServiceElementChangeManager();
        }
        context.getServiceBeanManager().addListener(this.svcElementListener);
        this.initProperties(update);
        this.connected = true;
        try {
            this.totalServices = this.getTotalKnownServices();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]:Discovering peer environment", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServiceElement(ServiceElement newElem) {
        ServiceElement serviceElement = this.sElem;
        synchronized (serviceElement) {
            this.sElem = newElem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceElement getServiceElement() {
        ServiceElement elem = null;
        ServiceElement serviceElement = this.sElem;
        synchronized (serviceElement) {
            elem = this.sElem;
        }
        return elem;
    }

    private void initProperties(boolean update) {
        try {
            Configuration config = this.getConfiguration();
            boolean sendRemoteNotification = (Boolean)config.getEntry(COMPONENT, SEND_NOTIFICATION, Boolean.TYPE, (Object)true);
            this.setSendRemoteNotification(sendRemoteNotification);
            this.destroyOnDecrement = (Boolean)config.getEntry(COMPONENT, DESTROY_DECREMENT, Boolean.TYPE, (Object)true);
            this.maxServices = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)MAX_SERVICES, (int)-1, (int)-1, (int)Integer.MAX_VALUE);
            int deprecatedMin = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)MIN_SERVICES, (int)-1, (int)-1, (int)Integer.MAX_VALUE);
            if (deprecatedMin != -1) {
                logger.info("[" + this.getName() + "] The " + COMPONENT + "." + MIN_SERVICES + " configuration property has been deprecated. The value provided by the <Maintain> element is used to determine the number of minimum services");
            }
            if (!update) {
                this.minServices = this.context.getServiceElement().getPlanned();
                Integer ips = (Integer)this.context.getServiceBeanConfig().getConfigurationParamaters().get("initial.planned");
                if (ips != null) {
                    this.minServices = ips;
                }
            }
            this.upperThresholdDampeningTime = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)UPPER_DAMPER, (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            this.lowerThresholdDampeningTime = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)LOWER_DAMPER, (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            if (logger.isLoggable(Level.FINE)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("[" + this.getName() + "] ");
                buffer.append("ScalingPolicyHandler [" + this.getID() + "]: properties\n");
                buffer.append("low Threshold=" + this.getSLA().getLowThreshold() + ", ");
                buffer.append("high Threshold=" + this.getSLA().getHighThreshold() + ", ");
                buffer.append("sendRemoteNotification=" + sendRemoteNotification + ", ");
                buffer.append("destroyOnDecrement=" + this.destroyOnDecrement + ", ");
                buffer.append("maxServices=" + this.maxServices + ", ");
                buffer.append("minServices=" + this.minServices + ", ");
                buffer.append("upperThresholdDampeningTime=" + this.upperThresholdDampeningTime + ", ");
                buffer.append("lowerThresholdDampeningTime=" + this.lowerThresholdDampeningTime);
                logger.fine(buffer.toString());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Getting Operational Configuration", e);
        }
    }

    public void setDestroyOnDecrement(boolean destroyOnDecrement) {
        this.destroyOnDecrement = destroyOnDecrement;
    }

    public boolean getDestroyOnDecrement() {
        return this.destroyOnDecrement;
    }

    @Override
    public void notify(Calculable calculable, ThresholdValues thresholdValues, int type) {
        String status;
        if (!this.connected) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: has been disconnected");
            }
            return;
        }
        String string = status = type == 0 ? "breached" : "cleared";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: Threshold [" + calculable.getId() + "] " + status + " value [" + calculable.getValue() + "] low [" + thresholdValues.getCurrentLowThreshold() + "] high [" + thresholdValues.getCurrentHighThreshold() + "]");
        }
        if (this.context.getServiceBeanManager().getOperationalStringManager() == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("[" + this.getName() + "] No OperationalStringManager, unable to process event");
            }
            return;
        }
        if (type == 0) {
            int planned = this.getServiceElement().getPlanned();
            double tValue = calculable.getValue();
            if (tValue > thresholdValues.getCurrentHighThreshold()) {
                boolean increment = false;
                if (this.maxServices == -1) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: Unknown MaxServices number, choose to increment");
                    }
                    increment = true;
                } else {
                    try {
                        this.totalServices = this.getTotalKnownServices();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]:Getting instance count", e);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: planned [" + planned + "], totalServices [" + this.totalServices + "], maxServices   [" + this.maxServices + "]");
                    }
                    if (this.maxServices > this.totalServices && this.totalServices <= planned && this.maxServices > planned) {
                        increment = true;
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: MaxServices [" + this.maxServices + "] reached, do not increment");
                    }
                }
                if (increment) {
                    if (this.decrementTask != null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: cancel decrement task");
                        }
                        this.decrementTask.cancel();
                        this.decrementTask = null;
                    }
                    if (this.upperThresholdDampeningTime > 0L) {
                        this.incrementTask = new ScalingTask(true);
                        long now = System.currentTimeMillis();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: Schedule increment task in [" + this.upperThresholdDampeningTime + "] millis");
                        }
                        try {
                            this.taskTimer.schedule((TimerTask)this.incrementTask, new Date(now + this.upperThresholdDampeningTime));
                        }
                        catch (IllegalStateException e) {
                            logger.log(Level.WARNING, "Force disconnect of [" + this.getName() + "] ScalingPolicyHandler", e);
                            this.disconnect();
                        }
                    } else {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: no upper dampener, perform increment");
                        }
                        this.doIncrement();
                    }
                }
            } else {
                if (this.incrementTask != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: cancel increment task");
                    }
                    this.incrementTask.cancel();
                    this.incrementTask = null;
                }
                if (planned > this.minServices) {
                    if (this.lowerThresholdDampeningTime > 0L) {
                        this.scheduleDecrement();
                    } else {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: no lower dampener, perform decrement");
                        }
                        this.doDecrement();
                    }
                } else {
                    logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: MinServices [" + this.minServices + "] reached, Total services [" + this.totalServices + "] do not decrement");
                }
            }
        } else {
            if (this.incrementTask != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: cancel increment task");
                }
                this.incrementTask.cancel();
                this.incrementTask = null;
            }
            if (this.decrementTask != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: cancel decrement task");
                }
                this.decrementTask.cancel();
                this.decrementTask = null;
            }
            OperationalStringManager opMgr = this.context.getServiceBeanManager().getOperationalStringManager();
            int pendingCount = this.getPendingRequestCount(opMgr);
            logger.finest("[" + this.getID() + "] totalServices=" + this.totalServices + ", pendingCount=" + this.pendingRequests + ", pendingRequests=" + this.pendingRequests + ", planned=" + this.getServiceElement().getPlanned());
            if (this.totalServices + pendingCount + this.pendingRequests > this.getServiceElement().getPlanned()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[" + this.getID() + "] totalServices=" + this.totalServices + ", pendingCount=" + this.pendingRequests + ", pendingRequests=" + this.pendingRequests + ", planned=" + this.getServiceElement().getPlanned() + ", ");
                }
                try {
                    int numTrimmed = opMgr.trim(this.getServiceElement(), this.pendingRequests);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("[" + this.getID() + "] numTrimmed=" + numTrimmed);
                    }
                }
                catch (NoSuchObjectException e) {
                    logger.log(Level.WARNING, "Remote manager decomissioned for [" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "], force disconnect");
                    this.disconnect();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "[" + this.getID() + "] Trimming Pending Requests", e);
                }
            }
        }
        this.sendSLAThresholdEvent(calculable, thresholdValues, type);
    }

    @Override
    public void succeeded(ServiceBeanInstance jsbInstance) throws RemoteException {
        try {
            --this.pendingRequests;
            this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), INCREMENT_SUCCEEDED, jsbInstance.getService()));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Getting service to create SLAPolicyEvent", e);
        }
    }

    @Override
    public void failed(ServiceElement sElem, boolean resubmitted) throws RemoteException {
        if (!resubmitted) {
            --this.pendingRequests;
        }
        this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), INCREMENT_FAILURE));
    }

    public TrustVerifier getProxyVerifier() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(this.getClass().getName(), "getProxyVerifier");
        }
        if (this.ourRemoteRef == null) {
            this.exportDo();
        }
        return new BasicProxyTrustVerifier(this.ourRemoteRef);
    }

    private int getPendingRequestCount(OperationalStringManager opMgr) {
        int pendingCount = 0;
        try {
            opMgr.getClass().getMethod("getPendingCount", ServiceElement.class);
            ServiceElement elem = this.getServiceElement();
            pendingCount = opMgr.getPendingCount(elem);
        }
        catch (NoSuchObjectException e) {
            logger.log(Level.WARNING, "Remote manager decomissioned for [" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "], force disconnect");
            this.disconnect();
        }
        catch (Throwable t) {
            logger.warning("Using pre-3.2 " + opMgr.getClass().getName() + ", pending count not available");
        }
        return pendingCount;
    }

    private String getName() {
        String name = this.getServiceElement().getName();
        Long iID = this.getServiceElement().getServiceBeanConfig().getInstanceID();
        if (iID > 0L) {
            name = name + ":" + iID;
        }
        return name;
    }

    private int getTotalKnownServices() throws Exception {
        OperationalStringManager opMgr = this.context.getServiceBeanManager().getOperationalStringManager();
        if (opMgr == null) {
            throw new Exception("OperationalStringManager is null");
        }
        ServiceBeanInstance[] instances = opMgr.getServiceBeanInstances(this.getServiceElement());
        return instances.length;
    }

    private void doIncrement() {
        try {
            OperationalStringManager opMgr = this.context.getServiceBeanManager().getOperationalStringManager();
            if (opMgr == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("[" + this.getName() + "] No OperationalStringManager, increment aborted");
                }
                return;
            }
            ServiceElement elem = this.getServiceElement();
            ServiceBeanInstance[] instances = opMgr.getServiceBeanInstances(elem);
            int pendingCount = this.getPendingRequestCount(opMgr);
            int realTotal = instances.length + pendingCount;
            boolean increment = false;
            if (this.maxServices == -1) {
                increment = true;
            } else if (this.maxServices > realTotal && realTotal <= this.getServiceElement().getPlanned() && this.maxServices > this.getServiceElement().getPlanned()) {
                increment = true;
            }
            if (increment) {
                if (logger.isLoggable(Level.FINE)) {
                    String sMax = this.maxServices == -1 ? "Undefined" : Integer.toString(this.maxServices);
                    logger.fine("[" + this.getName() + "] Current instance count=[" + instances.length + "], Current pending count=[" + pendingCount + "], Planned=[" + this.getServiceElement().getPlanned() + "], MaxServices=[" + sMax + "], ScalingPolicyHandler [" + this.getID() + "]: INCREMENT_PENDING");
                }
                this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), INCREMENT_PENDING));
                if (this.ourRemoteRef == null) {
                    this.exportDo();
                }
                this.context.getServiceBeanManager().increment((ServiceProvisionListener)this.ourRemoteRef);
                ++this.pendingRequests;
            } else if (logger.isLoggable(Level.FINE)) {
                String sMax = this.maxServices == -1 ? "Undefined" : Integer.toString(this.maxServices);
                logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: Current instance count=[" + instances.length + "], Current pending count=[" + pendingCount + "], Planned=[" + this.getServiceElement().getPlanned() + "], MaxServices=[" + sMax + "], INCREMENT CANCELLED");
            }
        }
        catch (NoSuchObjectException e) {
            logger.log(Level.WARNING, "Remote manager decomissioned for [" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "], force disconnect");
            this.disconnect();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "INCREMENT FAILED", e);
            this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), INCREMENT_FAILURE));
        }
    }

    void scheduleDecrement() {
        this.decrementTask = new ScalingTask(false);
        long now = System.currentTimeMillis();
        logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: schedule decrement task in [" + this.lowerThresholdDampeningTime + "] millis");
        try {
            this.taskTimer.schedule((TimerTask)this.decrementTask, new Date(now + this.lowerThresholdDampeningTime));
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, "Force disconnect of [" + this.getName() + "] ScalingPolicyHandler", e);
            this.disconnect();
        }
    }

    private void doDecrement() {
        OperationalStringManager opMgr = this.context.getServiceBeanManager().getOperationalStringManager();
        if (opMgr == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: unable to process decrement, null OperationalStringManager, abort decrement request");
            }
            return;
        }
        boolean reschedule = true;
        try {
            ServiceBeanInstance[] instances = opMgr.getServiceBeanInstances(this.getServiceElement());
            this.totalServices = instances.length;
            for (int i = 0; i < instances.length; ++i) {
                if (!instances[i].getServiceBeanID().equals((Object)this.context.getServiceBeanManager().getServiceID())) continue;
                reschedule = false;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (reschedule) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: instance not in OperationalStringManager, reschedule decrement request");
            }
            this.scheduleDecrement();
            return;
        }
        if (this.totalServices > this.minServices) {
            try {
                this.haveDecremented = this.destroyOnDecrement;
                this.context.getServiceBeanManager().decrement(this.destroyOnDecrement);
                this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), this.destroyOnDecrement ? DECREMENT_DESTROY_SENT : DECREMENT_SENT));
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("[" + this.getName() + "] ScalingPolicyHandler [" + this.getID() + "]: " + (this.destroyOnDecrement ? DECREMENT_DESTROY_SENT : DECREMENT_SENT));
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "DECREMENT FAILED", e);
                this.notifyListeners(new SLAPolicyEvent(this, this.getSLA(), DECREMENT_FAILED));
            }
        }
    }

    private void exportDo() {
        try {
            this.ourRemoteRef = this.exporter.export((Remote)this);
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, "Exporting ScalingPolicyHandler [" + this.getID() + "]", e);
        }
    }

    class ScalingTask
    extends TimerTask {
        boolean increment;

        ScalingTask(boolean increment) {
            this.increment = increment;
        }

        @Override
        public void run() {
            if (this.increment) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("[" + ScalingPolicyHandler.this.getName() + "] ScalingPolicyHandler [" + ScalingPolicyHandler.this.getID() + "]: running increment task");
                }
                ScalingPolicyHandler.this.doIncrement();
                ScalingPolicyHandler.this.incrementTask = null;
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("[" + ScalingPolicyHandler.this.getName() + "] ScalingPolicyHandler [" + ScalingPolicyHandler.this.getID() + "]: running decrement task");
                }
                ScalingPolicyHandler.this.decrementTask = null;
                if (!ScalingPolicyHandler.this.haveDecremented) {
                    ScalingPolicyHandler.this.doDecrement();
                }
            }
        }
    }

    class ServiceElementChangeManager
    implements ServiceElementChangeListener {
        ServiceElementChangeManager() {
        }

        @Override
        public void changed(ServiceElement preElem, ServiceElement postElem) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("ServiceElement change notification");
            }
            ScalingPolicyHandler.this.setServiceElement(postElem);
        }
    }
}

