/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos;

import com.gigaspaces.internal.io.BootIOUtils;
import java.io.File;
import java.io.FileFilter;
import java.rmi.activation.ActivationGroup;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.jini.rio.qos.SystemCapabilitiesLoader;
import org.jini.rio.qos.capability.PlatformCapability;
import org.jini.rio.qos.measurable.MeasurableCapability;
import org.jini.rio.qos.measurable.cpu.CPU;
import org.jini.rio.qos.measurable.disk.DiskSpace;
import org.jini.rio.qos.measurable.memory.Memory;

public class SystemCapabilities
implements SystemCapabilitiesLoader {
    public static final String NATIVE_LIBS = "org.jini.rio.qos.native";
    public static final String PROCESSOR = "org.jini.rio.qos.capability.system.ProcessorArchitecture";
    public static final String TCPIP = "org.jini.rio.qos.capability.connectivity.TCPConnectivity";
    public static final String J2SE = "org.jini.rio.qos.capability.software.J2SESupport";
    public static final String J2ME = "org.jini.rio.qos.capability.software.J2MESupport";
    public static final String RMI_ACTIVATION = "org.jini.rio.qos.capability.system.RMIActivation";
    public static final String MEMORY = "org.jini.rio.qos.capability.system.Memory";
    public static final String STORAGE = "org.jini.rio.qos.capability.system.StorageCapability";
    public static final String NATIVE_LIB_CLASS = "org.jini.rio.qos.capability.software.NativeLibrarySupport";
    public static final String RIO = "org.jini.rio.qos.capability.software.RioSupport";
    static final String COMPONENT = "org.jini.rio.qos";
    static Logger logger = Logger.getLogger("org.jini.rio.qos");

    @Override
    public MeasurableCapability[] getMeasurableCapabilities(Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        Vector<MeasurableCapability> measurables = new Vector<MeasurableCapability>();
        Memory memory = new Memory(config);
        measurables.add(memory);
        CPU cpu = new CPU(config);
        measurables.add(cpu);
        DiskSpace diskSpace = new DiskSpace(config);
        measurables.add(diskSpace);
        try {
            MeasurableCapability[] mCaps = (MeasurableCapability[])config.getEntry(COMPONENT, "measurableCapabilities", MeasurableCapability[].class, null);
            if (mCaps != null) {
                for (int i = 0; i < mCaps.length; ++i) {
                    measurables.add(mCaps[i]);
                }
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Loading MeasurableCapability array", e);
        }
        return measurables.toArray(new MeasurableCapability[measurables.size()]);
    }

    @Override
    public PlatformCapability[] getPlatformCapabilities(Configuration config) {
        Vector<PlatformCapability> platforms = new Vector<PlatformCapability>();
        try {
            PlatformCapability memory;
            PlatformCapability storage;
            int i;
            PlatformCapability processor = this.getPlatformCapability(PROCESSOR);
            processor.define("Architecture", System.getProperty("os.arch"));
            processor.define("OSName", System.getProperty("os.name"));
            processor.define("OSVersion", System.getProperty("os.version"));
            processor.define("NumberOfProcessors", Integer.toString(Runtime.getRuntime().availableProcessors()));
            platforms.add(processor);
            PlatformCapability tcpip = this.getPlatformCapability(TCPIP);
            platforms.add(tcpip);
            String jvmName = System.getProperty("java.vm.name");
            if (jvmName != null) {
                PlatformCapability j2se = this.getPlatformCapability(J2SE);
                j2se.define("Version", System.getProperty("java.version"));
                j2se.define("Description", jvmName);
                j2se.define("Name", "Java");
                String javaHome = System.getProperty("java.home");
                if (javaHome != null) {
                    j2se.setPath(javaHome);
                }
                platforms.add(j2se);
            }
            if (ActivationGroup.currentGroupID() != null) {
                PlatformCapability rmiActivation = this.getPlatformCapability(RMI_ACTIVATION);
                platforms.add(rmiActivation);
            }
            PlatformCapability[] pCaps = (PlatformCapability[])config.getEntry(COMPONENT, "platformCapabilities", PlatformCapability[].class, (Object)new PlatformCapability[0]);
            PlatformCapability[] addCaps = (PlatformCapability[])config.getEntry(COMPONENT, "addPlatformCapabilities", PlatformCapability[].class, (Object)new PlatformCapability[0]);
            ArrayList<PlatformCapability> list = new ArrayList<PlatformCapability>();
            for (i = 0; i < pCaps.length; ++i) {
                list.add(pCaps[i]);
            }
            for (i = 0; i < addCaps.length; ++i) {
                list.add(addCaps[i]);
            }
            pCaps = list.toArray(new PlatformCapability[list.size()]);
            boolean haveRio = false;
            for (int i2 = 0; i2 < pCaps.length; ++i2) {
                if (pCaps[i2].getClass().getName().equals(RIO)) {
                    haveRio = true;
                }
                platforms.add(pCaps[i2]);
            }
            if (!haveRio) {
                PlatformCapability rio = this.getPlatformCapability(RIO);
                rio.define("Version", "3.2");
                String path = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        CodeSource cs = SystemCapabilities.class.getProtectionDomain().getCodeSource();
                        String path = null;
                        if (cs != null) {
                            path = cs.getLocation().toString();
                        }
                        return path;
                    }
                });
                if (path != null) {
                    if (path.startsWith("file:")) {
                        path = path.substring(5, path.length());
                    }
                    rio.setPath(path);
                }
                platforms.add(rio);
            }
            if ((storage = this.findCapability(platforms, STORAGE)) == null) {
                storage = this.getPlatformCapability(STORAGE);
                platforms.add(storage);
            }
            if ((memory = this.findCapability(platforms, MEMORY)) == null) {
                memory = this.getPlatformCapability(MEMORY);
                platforms.add(memory);
            }
            String nativeLibDirs = System.getProperty(NATIVE_LIBS);
            ArrayList<File> dirList = new ArrayList<File>();
            if (nativeLibDirs != null && nativeLibDirs.length() > 0) {
                StringTokenizer st = new StringTokenizer(nativeLibDirs);
                while (st.hasMoreTokens()) {
                    String dirName = st.nextToken();
                    File dir = new File(dirName);
                    if (dir.isDirectory() && dir.canRead()) {
                        dirList.add(dir);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("Adding directory [" + dirName + "] to check for native libraries");
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Invalid directory name or access permissions [" + dirName + "]");
                }
                final String libExtension = this.getLibExtension();
                File[] dirs = dirList.toArray(new File[dirList.size()]);
                for (int i3 = 0; i3 < dirs.length; ++i3) {
                    File[] files = BootIOUtils.listFiles((File)dirs[i3], (FileFilter)new FileFilter(){

                        @Override
                        public boolean accept(File pathName) {
                            return pathName.getName().endsWith(libExtension);
                        }
                    });
                    for (int j = 0; j < files.length; ++j) {
                        String fileName = files[j].getName();
                        int index = fileName.lastIndexOf(".");
                        if (index != -1) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Create NativeLibrarySupport object for [" + fileName + "]");
                            }
                            PlatformCapability nLib = this.getPlatformCapability(NATIVE_LIB_CLASS);
                            String name = null;
                            name = !System.getProperty("os.name").startsWith("Windows") ? fileName.substring(3, index) : fileName.substring(0, index);
                            nLib.define("Name", name);
                            nLib.define("FileName", fileName);
                            nLib.setPath(dirs[i3].getCanonicalPath());
                            platforms.add(nLib);
                            continue;
                        }
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("Illegal Shared Library name=" + fileName);
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Getting PlatformCapability objects", t);
        }
        return platforms.toArray(new PlatformCapability[platforms.size()]);
    }

    protected PlatformCapability getPlatformCapability(String className) throws Exception {
        Class<?> pCapClass = Class.forName(className);
        return (PlatformCapability)pCapClass.newInstance();
    }

    private PlatformCapability findCapability(Vector v, String name) {
        PlatformCapability o = null;
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            PlatformCapability pCap = (PlatformCapability)en.nextElement();
            if (!pCap.getClass().getName().equals(name)) continue;
            o = pCap;
            break;
        }
        return o;
    }

    private String getLibExtension() {
        String opSys = System.getProperty("os.name");
        if (opSys.startsWith("Windows")) {
            return "dll";
        }
        if (opSys.startsWith("Mac")) {
            return "jnilib";
        }
        return "so";
    }
}

