/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.capability;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jini.rio.core.ResourceCost;
import org.jini.rio.core.ResourceCostModel;
import org.jini.rio.core.ResourceCostProducer;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.ZeroCostModel;
import org.jini.rio.core.provision.SoftwareDownloadRecord;
import org.jini.rio.core.provision.SoftwareLoad;
import org.jini.rio.qos.capability.PlatformCapabilityMBean;

public class PlatformCapability
implements PlatformCapabilityMBean,
ResourceCostProducer,
Serializable {
    static final long serialVersionUID = 1L;
    public static final String MANUFACTURER = "Manufacturer";
    public static final String MODEL = "Model";
    public static final String NAME = "Name";
    public static final String VENDOR = "Vendor";
    public static final String VERSION = "Version";
    public static final String DESCRIPTION = "Description";
    public static final String NATIVE_LIBS = "NativeLibs";
    public static final int STATIC = 1;
    public static final int PROVISIONABLE = 2;
    private int type = 1;
    protected Hashtable capabilities = new Hashtable();
    protected String description;
    protected SoftwareLoad softwareLoad;
    protected List downloadRecords = new ArrayList();
    protected String path;
    private ResourceCostModel costModel;
    private static final String[] META_CHARS = new String[]{"*", "(", "[", "\\", "^", "$", "|", ")", "?", "+"};
    protected static final Logger logger = Logger.getLogger("org.jini.rio.qos.capability");

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void loadResources() {
        String values = (String)this.capabilities.get(NATIVE_LIBS);
        if (values == null) {
            return;
        }
        StringTokenizer sTok = new StringTokenizer(values, " \t\n\r\f:");
        while (sTok.hasMoreTokens()) {
            String libName = sTok.nextToken();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loading [" + libName + "] for " + this.getClass().getName());
            }
            System.out.println("Loading [" + libName + "] for " + this.getClass().getName());
            System.loadLibrary(libName);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loaded [" + libName + "] for " + this.getClass().getName());
            }
            System.out.println("Loaded [" + libName + "] for " + this.getClass().getName());
        }
    }

    public void defineAll(Object[] mapping) {
        if (mapping == null) {
            return;
        }
        if (mapping.length % 2 != 0) {
            throw new IllegalArgumentException("elements has odd length");
        }
        for (int i = 0; i < mapping.length; i += 2) {
            this.define(mapping[i], mapping[i + 1]);
        }
    }

    public void define(Object key, Object value) {
        this.capabilities.put(key, value);
        if (key instanceof String && key.equals(DESCRIPTION)) {
            this.description = value.toString();
        }
    }

    public void defineAll(Map map) {
        this.capabilities.putAll(map);
        Enumeration en = this.capabilities.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (!(key instanceof String) || !key.equals(DESCRIPTION)) continue;
            this.description = this.capabilities.get(key).toString();
        }
    }

    public Object getValue(Object key) {
        return this.capabilities.get(key);
    }

    public boolean remove(Object key) {
        Object o = this.capabilities.remove(key);
        return o != null;
    }

    public void clearAll() {
        this.capabilities.clear();
    }

    @Deprecated
    public boolean supports(PlatformCapability requirement) {
        boolean supports = this.getClass().getName().equals(requirement.getClass().getName());
        if (supports) {
            Object[] keys = requirement.getPlatformKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (this.capabilities.containsKey(keys[i])) {
                    Object theirMapping;
                    Object myMapping = this.capabilities.get(keys[i]);
                    if (myMapping.equals(theirMapping = requirement.getValue(keys[i]))) continue;
                    supports = false;
                    break;
                }
                supports = false;
                break;
            }
        }
        return supports;
    }

    public boolean supports(ServiceLevelAgreements.SystemRequirement requirement) {
        boolean supports = this.hasBasicSupport(requirement.getName(), requirement.getClassName());
        if (supports) {
            Map attributes = requirement.getAttributes();
            for (Map.Entry mapEntry : attributes.entrySet()) {
                Object key = mapEntry.getKey();
                if (this.capabilities.containsKey(key)) {
                    Object myMapping = this.capabilities.get(key);
                    Object theirMapping = mapEntry.getValue();
                    if (myMapping instanceof String && theirMapping instanceof String) {
                        if (key.equals(VERSION)) {
                            if (this.versionSupported((String)theirMapping, (String)myMapping)) continue;
                            supports = false;
                            break;
                        }
                        if (this.matches((String)theirMapping, (String)myMapping)) continue;
                        supports = false;
                        break;
                    }
                    if (myMapping.equals(theirMapping)) continue;
                    supports = false;
                    break;
                }
                supports = false;
                break;
            }
        }
        return supports;
    }

    protected boolean hasBasicSupport(String name, String className) {
        if (name == null && className == null) {
            throw new NullPointerException("className and name cannot both be null");
        }
        boolean supports = false;
        String myClassName = this.getClass().getName();
        if (name != null) {
            String myName = myClassName;
            int ndx = myClassName.lastIndexOf(".");
            if (ndx > 0) {
                myName = myClassName.substring(ndx + 1);
            }
            supports = myName.equals(name);
        }
        if (!supports && className != null) {
            supports = myClassName.equals(className);
        }
        return supports;
    }

    protected boolean matches(String input, String value) {
        boolean useFind = false;
        for (int i = 0; i < META_CHARS.length; ++i) {
            if (input.indexOf(META_CHARS[i]) == -1) continue;
            useFind = true;
            break;
        }
        Pattern pattern = Pattern.compile(input);
        Matcher matcher = pattern.matcher(value);
        boolean matches = false;
        matches = useFind ? matcher.find() : matcher.matches();
        return matches;
    }

    protected boolean versionSupported(String requiredVersion, String configuredVersion) {
        if (requiredVersion == null) {
            throw new NullPointerException("requiredVersion is null");
        }
        if (configuredVersion == null) {
            throw new NullPointerException("configuredVersion is null");
        }
        boolean supported = false;
        if (requiredVersion.endsWith("*") || requiredVersion.endsWith("+")) {
            boolean minorVersionSupport = requiredVersion.endsWith("*");
            requiredVersion = requiredVersion.substring(0, requiredVersion.length() - 1);
            int[] required = null;
            int[] configured = null;
            try {
                required = this.toIntArray(requiredVersion.split("\\D"));
                configured = this.toIntArray(configuredVersion.split("\\D"));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (required.length == 0) {
                return true;
            }
            if (minorVersionSupport) {
                supported = true;
                for (int i = 0; i < required.length; ++i) {
                    if (configured.length < i + 1 || configured[i] == required[i]) continue;
                    supported = false;
                    break;
                }
            } else {
                supported = true;
                for (int i = 0; i < required.length; ++i) {
                    if (configured.length < i + 1) continue;
                    if (configured[i] <= required[i]) {
                        if (configured[i] == required[i] || configured[i] >= required[i]) continue;
                        supported = false;
                    }
                    break;
                }
            }
        } else {
            supported = configuredVersion.equals(requiredVersion);
        }
        return supported;
    }

    private int[] toIntArray(String[] a) throws NumberFormatException {
        int[] array = new int[a.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = a[i].length() == 0 ? Integer.parseInt("0") : Integer.parseInt(a[i]);
        }
        return array;
    }

    public Object[] getPlatformKeys() {
        return this.capabilities.keySet().toArray();
    }

    public void setDescription(String description) {
        if (description != null) {
            this.description = description;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getName() {
        String s = (String)this.getValue(NAME);
        return s == null ? "" : s;
    }

    @Override
    public Map getCapabilities() {
        Hashtable h = new Hashtable();
        h.putAll(this.capabilities);
        return h;
    }

    public void setResourceCostModel(ResourceCostModel costModel) {
        if (costModel == null) {
            throw new NullPointerException("costModel is null");
        }
        this.costModel = costModel;
    }

    @Override
    public ResourceCost calculateResourceCost(double units, long duration) {
        if (this.costModel == null) {
            this.costModel = new ZeroCostModel(0.0);
        }
        double cost = this.costModel.getCostPerUnit(duration) * units;
        return new ResourceCost(this.getDescription(), cost, units, this.costModel.getDescription(), new Date(System.currentTimeMillis()));
    }

    public void setSoftwareLoad(SoftwareLoad softwareLoad) {
        if (softwareLoad == null) {
            throw new NullPointerException("softwareLoad is null");
        }
        this.softwareLoad = softwareLoad;
        this.setType(2);
    }

    public SoftwareLoad getSoftwareLoad() {
        return this.softwareLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSoftwareDownloadRecord(SoftwareDownloadRecord record) {
        if (record == null) {
            throw new NullPointerException("record is null");
        }
        List list = this.downloadRecords;
        synchronized (list) {
            this.downloadRecords.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoftwareDownloadRecord[] getSoftwareDownloadRecords() {
        SoftwareDownloadRecord[] records = null;
        List list = this.downloadRecords;
        synchronized (list) {
            records = this.downloadRecords.toArray(new SoftwareDownloadRecord[this.downloadRecords.size()]);
        }
        return records;
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("bad type : " + type);
        }
        this.type = type;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + this.getClass().hashCode();
        hc = 37 * hc + this.capabilities.hashCode();
        return hc;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            PlatformCapability that = (PlatformCapability)obj;
            return this.capabilities.equals(that.capabilities);
        }
        return false;
    }

    public String toString() {
        return (this.description == null ? "<no description>" : this.description) + ": " + this.capabilities.toString();
    }
}

