/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.capability.connectivity;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.logging.Level;
import org.jini.rio.qos.capability.connectivity.ConnectivityCapability;

public class TCPConnectivity
extends ConnectivityCapability {
    static final long serialVersionUID = 1L;
    static final String DEFAULT_DESCRIPTION = "TCP/IP Connectivity";
    public static final String IPv6_NIC = "IPv6 NICs";
    public static final String IPv4_NIC = "IPv4 NICs";

    public TCPConnectivity() {
        this(DEFAULT_DESCRIPTION);
    }

    public TCPConnectivity(String description) {
        super(description, new Object[]{"Name", "Network"});
        int ipv4Nics = 0;
        int ipv6Nics = 0;
        StringBuffer ipv4buff = new StringBuffer();
        StringBuffer ipv6buff = new StringBuffer();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface nic = en.nextElement();
                Enumeration<InetAddress> en1 = nic.getInetAddresses();
                while (en1.hasMoreElements()) {
                    InetAddress addr = en1.nextElement();
                    if (addr instanceof Inet6Address) {
                        if (ipv6Nics > 0) {
                            ipv6buff.append(", ");
                        }
                        ipv6buff.append(nic.getName());
                        ++ipv6Nics;
                        continue;
                    }
                    if (ipv4Nics > 0) {
                        ipv4buff.append(", ");
                    }
                    ipv4buff.append(nic.getName());
                    ++ipv4Nics;
                }
            }
            this.define(IPv4_NIC, ipv4buff.toString());
            if (ipv6Nics > 0) {
                this.define(IPv6_NIC, ipv6buff.toString());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Getting NetworkInterfaces", e);
        }
    }
}

