/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.capability.software;

import java.util.Map;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.qos.capability.PlatformCapability;

public class J2SESupport
extends PlatformCapability {
    static final long serialVersionUID = 1L;
    static final String DEFAULT_DESCRIPTION = "Java 2 Standard Edition";

    public J2SESupport() {
        this.description = DEFAULT_DESCRIPTION;
    }

    public J2SESupport(String description) {
        this.description = description;
    }

    @Override
    public boolean supports(ServiceLevelAgreements.SystemRequirement requirement) {
        boolean supports = this.hasBasicSupport(requirement.getName(), requirement.getClassName());
        if (supports) {
            Map attributes = requirement.getAttributes();
            for (Map.Entry mapEntry : attributes.entrySet()) {
                Object key = mapEntry.getKey();
                if (this.capabilities.containsKey(key)) {
                    String testKey = (String)key;
                    String myMapping = (String)this.capabilities.get(key);
                    String theirMapping = (String)mapEntry.getValue();
                    if (testKey.equals("Version")) {
                        if (myMapping.startsWith("1.3") && (theirMapping.startsWith("1.5") || theirMapping.startsWith("1.4") || theirMapping.startsWith("1.0"))) {
                            supports = false;
                            break;
                        }
                        if (!myMapping.startsWith("1.4") || !theirMapping.startsWith("1.5") && !theirMapping.startsWith("1.0")) continue;
                        supports = false;
                        break;
                    }
                    if (this.matches(theirMapping, myMapping)) continue;
                    supports = false;
                    break;
                }
                supports = false;
                break;
            }
        }
        return supports;
    }
}

