/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.capability.system;

import java.util.Map;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.qos.capability.PlatformCapability;

public class ByteOrientedDevice
extends PlatformCapability {
    private static final long serialVersionUID = -5885630273205873028L;
    public static final String AVAILABLE = "Available";
    public static final String CAPACITY = "Capacity";
    public static final double KB = 1024.0;
    public static final double MB = Math.pow(1024.0, 2.0);
    public static final double GB = Math.pow(1024.0, 3.0);
    public static final double TB = Math.pow(1024.0, 4.0);

    @Override
    public void define(Object key, Object value) {
        if (key == null || value == null) {
            return;
        }
        if (key.equals(CAPACITY)) {
            try {
                Double dCap = new Double((String)value);
                this.capabilities.put(CAPACITY, dCap);
            }
            catch (NumberFormatException e) {
                System.out.println("Bad value for Capacity");
                e.printStackTrace();
            }
        } else if (key.equals(AVAILABLE)) {
            try {
                Double dAvail = new Double((String)value);
                this.capabilities.put(AVAILABLE, dAvail);
            }
            catch (NumberFormatException e) {
                System.out.println("Bad value for Available");
                e.printStackTrace();
            }
        } else {
            super.define(key, value);
        }
    }

    @Override
    public boolean supports(ServiceLevelAgreements.SystemRequirement requirement) {
        boolean supports = this.hasBasicSupport(requirement.getName(), requirement.getClassName());
        if (supports) {
            Map attributes = requirement.getAttributes();
            for (Map.Entry me : attributes.entrySet()) {
                Object key = me.getKey();
                String value = (String)me.getValue();
                if (value == null) continue;
                if (key.equals(CAPACITY)) {
                    Double dCap = (Double)this.getValue(CAPACITY);
                    if (dCap == null) break;
                    double capacity = dCap;
                    supports = this.evaluate(value, capacity);
                    break;
                }
                if (!key.equals(AVAILABLE)) continue;
                Double dAvail = (Double)this.getValue(AVAILABLE);
                if (dAvail == null) break;
                double available = dAvail;
                supports = this.evaluate(value, available);
                break;
            }
        }
        if (!supports) {
            return false;
        }
        return super.supports(requirement);
    }

    protected boolean evaluate(String input, double val) {
        boolean supports = true;
        double d = val;
        if (input.endsWith("k") || input.endsWith("K")) {
            d = val / 1024.0;
        } else if (input.endsWith("m") || input.endsWith("M")) {
            d = val / MB;
        } else if (input.endsWith("g") || input.endsWith("G")) {
            d = val / GB;
        } else if (input.endsWith("t") || input.endsWith("T")) {
            d = val / TB;
        } else {
            supports = false;
        }
        if (supports) {
            try {
                String s = input.substring(0, input.length() - 1);
                double requestedSize = new Double(s);
                supports = requestedSize < d;
            }
            catch (NumberFormatException e) {
                supports = false;
            }
        }
        return supports;
    }
}

