/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.capability.system;

import java.util.Map;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.qos.capability.PlatformCapability;

public class ProcessorArchitecture
extends PlatformCapability {
    static final long serialVersionUID = 1L;
    static final String DEFAULT_DESCRIPTION = "System Architecture";
    public static final String NUM_PROCESSORS = "NumberOfProcessors";
    public static final String ARCHITECTURE = "Architecture";
    public static final String OS_NAME = "OSName";
    public static final String OS_VERSION = "OSVersion";

    public ProcessorArchitecture() {
        this(DEFAULT_DESCRIPTION);
    }

    public ProcessorArchitecture(String description) {
        this.description = description;
        this.define("Name", "Processor");
    }

    @Override
    public boolean supports(ServiceLevelAgreements.SystemRequirement requirement) {
        boolean supports = this.hasBasicSupport(requirement.getName(), requirement.getClassName());
        if (supports) {
            Map attributes = requirement.getAttributes();
            for (Map.Entry mapEntry : attributes.entrySet()) {
                Object key = mapEntry.getKey();
                if (this.capabilities.containsKey(key)) {
                    String testKey = (String)key;
                    String myMapping = (String)this.capabilities.get(key);
                    String theirMapping = (String)mapEntry.getValue();
                    if (!(testKey.equals(NUM_PROCESSORS) ? !(supports = this.checkNumberOfProcessors(myMapping, theirMapping)) : !(supports = this.matches(theirMapping, myMapping)))) continue;
                    break;
                }
                supports = false;
                break;
            }
        }
        return supports;
    }

    private boolean checkNumberOfProcessors(String myNumberOfProcessors, String requestedNumberOfProcessors) {
        try {
            int myNProcessors = Integer.parseInt(myNumberOfProcessors);
            int requestNProcessors = Integer.parseInt(requestedNumberOfProcessors);
            return myNProcessors >= requestNProcessors;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

