/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.capability.system;

import java.lang.reflect.Method;
import java.util.Observable;
import java.util.Observer;
import org.jini.rio.qos.capability.system.ByteOrientedDevice;

public class StorageCapability
extends ByteOrientedDevice
implements Observer {
    static final long serialVersionUID = 1L;
    static final String DEFAULT_DESCRIPTION = "Storage Capability";
    public static final String TYPE = "StorageType";

    public StorageCapability() {
        this(DEFAULT_DESCRIPTION);
    }

    public StorageCapability(String description) {
        this.description = description;
        this.define("Name", "Disk");
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            Method getAvailable = arg.getClass().getMethod("getAvailable", null);
            Double dAvail = (Double)getAvailable.invoke(arg, (Object[])null);
            Method getCapacity = arg.getClass().getMethod("getCapacity", null);
            Double dCap = (Double)getCapacity.invoke(arg, (Object[])null);
            this.capabilities.put("Capacity", dCap);
            this.capabilities.put("Available", dAvail);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean supports(int requestedSize) {
        double available = 0.0;
        Double dAvail = (Double)this.getValue("Available");
        if (dAvail != null) {
            dAvail.doubleValue();
        }
        return (double)requestedSize < available;
    }
}

