/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.measurable;

import java.util.Collection;
import java.util.Date;
import java.util.Observable;
import java.util.Vector;
import java.util.logging.Level;
import net.jini.config.Configuration;
import org.jini.rio.core.MeasuredResource;
import org.jini.rio.core.ResourceCost;
import org.jini.rio.core.ResourceCostModel;
import org.jini.rio.core.ResourceCostProducer;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ZeroCostModel;
import org.jini.rio.qos.measurable.MeasurableCapabilityMBean;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.PeriodicWatch;
import org.jini.rio.watch.ThresholdManager;
import org.jini.rio.watch.WatchDataSource;

public abstract class MeasurableCapability
extends PeriodicWatch
implements ResourceCostProducer,
MeasurableCapabilityMBean {
    private Observatory observatory;
    private Collection thresholdManagers;
    private SLA sla;
    private ResourceCostModel costModel;
    protected int sampleSize = 1;
    private Configuration config;

    protected MeasurableCapability(String id, Configuration config) {
        super(id, config);
        this.config = config;
        this.observatory = new Observatory();
        this.thresholdManagers = new Vector();
        if (this.localRef != null) {
            this.localRef.setSize(100);
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void setWatchDataSource(WatchDataSource watchDataSource) {
        super.setWatchDataSource(watchDataSource);
        if (watchDataSource != null) {
            try {
                watchDataSource.setSize(100);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Setting WatchDataSource Size", e);
            }
        }
    }

    public void setSLA(SLA sla) {
        if (sla == null) {
            throw new NullPointerException("sla is null");
        }
        this.sla = sla;
        this.getThresholdManager().setThresholdValues(sla);
    }

    public SLA getSLA() {
        return this.sla;
    }

    @Override
    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    public void addSecondaryThresholdManager(ThresholdManager thresholdManager) {
        if (thresholdManager == null) {
            throw new NullPointerException("thresholdManager is null");
        }
        this.thresholdManagers.add(thresholdManager);
    }

    public void removeSecondaryThresholdManager(ThresholdManager thresholdManager) {
        if (thresholdManager != null) {
            this.thresholdManagers.remove(thresholdManager);
        }
    }

    public void setResourceCostModel(ResourceCostModel costModel) {
        if (costModel == null) {
            throw new NullPointerException("costModel is null");
        }
        this.costModel = costModel;
    }

    @Override
    public ResourceCost calculateResourceCost(double units, long duration) {
        if (this.costModel == null) {
            this.costModel = new ZeroCostModel(0.0);
        }
        double cost = this.costModel.getCostPerUnit(duration) * units;
        return new ResourceCost(this.getId(), cost, units, this.costModel.getDescription(), new Date(System.currentTimeMillis()));
    }

    public MeasuredResource getMeasuredResource() {
        return new MeasuredResource(this.getId(), this.getUtilization(), this.getThresholdManager().getThresholdValues());
    }

    @Override
    public void addWatchRecord(Calculable record) {
        super.addWatchRecord(record);
        this.observatory.stateChange(record);
        ThresholdManager[] tManagers = this.thresholdManagers.toArray(new ThresholdManager[this.thresholdManagers.size()]);
        for (int i = 0; i < tManagers.length; ++i) {
            tManagers[i].checkThreshold(record);
        }
    }

    public Observable getObservable() {
        return this.observatory;
    }

    static class Observatory
    extends Observable {
        Observatory() {
        }

        void stateChange(Calculable record) {
            this.setChanged();
            this.notifyObservers(record);
        }
    }
}

