/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.measurable.cpu;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.qos.measurable.MeasurableMonitor;
import org.jini.rio.resources.resource.ThreadPool;

public abstract class CPUExecHandler
implements MeasurableMonitor {
    static final String COMPONENT = "org.jini.rio.qos.measurable.cpu";
    static Logger logger = Logger.getLogger("org.jini.rio.qos.measurable.cpu");
    protected double utilization;
    protected ThreadPool tPool = new ThreadPool("CPUExecPool", 1, 1);

    public abstract String getCommand();

    public abstract void parse(InputStream var1);

    public abstract double getUtilization();

    @Override
    public void terminate() {
        this.tPool.destroy();
    }

    @Override
    public double getValue() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(this.getCommand());
            this.parse(process.getInputStream());
            this.waitFor(process, 5000L);
            Thread.sleep(10L);
            this.utilization = this.getUtilization();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "ExecHandler thread interrupted", e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "ExecHandler thread", e);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ExecHandler thread", e);
        }
        finally {
            if (process != null) {
                try {
                    process.getErrorStream().close();
                }
                catch (Exception e) {}
                try {
                    process.getInputStream().close();
                }
                catch (Exception e) {}
                try {
                    process.getOutputStream().close();
                }
                catch (Exception e) {}
                try {
                    process.destroy();
                }
                catch (Exception e) {}
            }
        }
        return this.utilization;
    }

    @Override
    public double[] getValues() {
        return new double[]{this.getValue()};
    }

    boolean waitFor(Process process, long timeout) throws InterruptedException {
        int interval = 200;
        for (long timeWaiting = 0L; timeWaiting < timeout; timeWaiting += 200L) {
            if (!this.isProcessAlive(process)) {
                return true;
            }
            Thread.sleep(200L);
        }
        return false;
    }

    boolean isProcessAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }
}

