/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.measurable.cpu;

import org.jini.rio.qos.measurable.MeasurableMonitor;

public class GenericCPUMeasurer
implements MeasurableMonitor {
    Thread runner;
    boolean active = false;
    Object lock = new Object();
    double max;
    double current;
    boolean measuring = true;

    public GenericCPUMeasurer() {
        this.runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (GenericCPUMeasurer.this.measuring) {
                    Object object = GenericCPUMeasurer.this.lock;
                    synchronized (object) {
                        double iteration = 0.0;
                        while (GenericCPUMeasurer.this.active) {
                            iteration += 1.0;
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                if (GenericCPUMeasurer.this.active) continue;
                                break;
                            }
                        }
                        GenericCPUMeasurer.this.current = iteration;
                        try {
                            GenericCPUMeasurer.this.lock.notifyAll();
                            GenericCPUMeasurer.this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
        };
        this.runner.setDaemon(true);
        this.runner.setPriority(1);
        this.runner.start();
    }

    @Override
    public void terminate() {
        this.measuring = false;
        this.active = false;
        this.runner.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValue() {
        double utilization = 0.0;
        try {
            Object object = this.lock;
            synchronized (object) {
                this.active = true;
                this.lock.notifyAll();
            }
            Thread.sleep(500L);
            this.active = false;
            object = this.lock;
            synchronized (object) {
                this.max = this.current > this.max ? this.current : this.max;
                utilization = this.max == 0.0 ? 0.0 : 1.0 - this.current / this.max;
            }
        }
        catch (InterruptedException e) {
            this.measuring = false;
            this.runner.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return utilization;
    }

    @Override
    public double[] getValues() {
        return new double[]{this.getValue()};
    }
}

