/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.measurable.cpu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.jini.rio.qos.measurable.MeasurableMonitor;

public class LinuxHandler
implements MeasurableMonitor {
    static double[] knownStats = new double[]{0.0, 0.0, 0.0, 0.0};
    static final String PROC_STAT = "/proc/stat";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValue() {
        File statFile = new File(PROC_STAT);
        FileReader fr = null;
        BufferedReader bf = null;
        double utilization = 0.0;
        try {
            fr = new FileReader(statFile);
            bf = new BufferedReader(fr, 8192);
            String line = null;
            while ((line = bf.readLine()) != null) {
                if (!line.startsWith("cpu ")) continue;
                String[] elements = line.split("\\s");
                double user = Double.parseDouble(elements[2]);
                double nice = Double.parseDouble(elements[3]);
                double kernel = Double.parseDouble(elements[4]);
                double idle = Double.parseDouble(elements[5]);
                double totalJiffies = user - knownStats[0] + (nice - knownStats[1]) + (kernel - knownStats[2]) + (idle - knownStats[3]);
                utilization += 1.0 - (idle - knownStats[3]) / totalJiffies;
                LinuxHandler.knownStats[0] = user;
                LinuxHandler.knownStats[1] = nice;
                LinuxHandler.knownStats[2] = kernel;
                LinuxHandler.knownStats[3] = idle;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bf != null) {
                try {
                    bf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return utilization;
    }

    @Override
    public double[] getValues() {
        return new double[]{this.getValue()};
    }

    @Override
    public void terminate() {
    }
}

