/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.measurable.cpu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.jini.rio.qos.measurable.cpu.CPUExecHandler;
import org.jini.rio.resources.resource.PoolableThread;
import org.jini.rio.resources.resource.ResourceUnavailableException;

public class MacTopOutputParser
extends CPUExecHandler {
    InputStream in;
    double utilization;

    @Override
    public void parse(InputStream in) {
        this.in = in;
        try {
            PoolableThread thread = (PoolableThread)this.tPool.get();
            thread.execute((Runnable)new Runner());
        }
        catch (ResourceUnavailableException e) {
            logger.log(Level.WARNING, "Parsing output", e);
        }
    }

    @Override
    public double getUtilization() {
        return this.utilization;
    }

    @Override
    public String getCommand() {
        return "top -l2 -n0 -R -F";
    }

    double getDouble(String sVal) {
        double dVal = 0.0;
        try {
            int ndx = sVal.indexOf("%");
            if (ndx != -1) {
                sVal = sVal.substring(0, ndx);
            }
            dVal = new Double(sVal) / 100.0;
        }
        catch (NumberFormatException e) {
            System.out.println("Bad value [" + sVal + "]");
        }
        return dVal;
    }

    class Runner
    implements Runnable {
        Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader br = null;
            try {
                InputStreamReader isr = new InputStreamReader(MacTopOutputParser.this.in);
                br = new BufferedReader(isr);
                String line = null;
                int i = 0;
                while ((line = br.readLine()) != null) {
                    int ndx = line.indexOf("CPU");
                    if (ndx == -1) continue;
                    if (i > 0) {
                        String newLine = line.substring(ndx);
                        if ((ndx = newLine.indexOf(":")) == -1) continue;
                        newLine = newLine.substring(ndx + 1);
                        StringTokenizer st = new StringTokenizer(newLine, " ");
                        while (st.hasMoreTokens()) {
                            String value = st.nextToken();
                            String category = st.nextToken();
                            if (!category.equalsIgnoreCase("idle")) continue;
                            MacTopOutputParser.this.utilization = 1.0 - MacTopOutputParser.this.getDouble(value);
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

