/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.measurable.cpu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.jini.rio.qos.measurable.cpu.CPUExecHandler;
import org.jini.rio.resources.resource.PoolableThread;
import org.jini.rio.resources.resource.ResourceUnavailableException;

public class MpstatOutputParser
extends CPUExecHandler {
    InputStream in;
    double utilization;

    @Override
    public void parse(InputStream in) {
        this.in = in;
        try {
            PoolableThread thread = (PoolableThread)this.tPool.get();
            thread.execute((Runnable)new Runner());
        }
        catch (ResourceUnavailableException e) {
            logger.log(Level.WARNING, "Parsing output", e);
        }
    }

    @Override
    public double getUtilization() {
        return this.utilization;
    }

    @Override
    public String getCommand() {
        return "mpstat";
    }

    class Runner
    implements Runnable {
        Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader br = null;
            try {
                InputStreamReader isr = new InputStreamReader(MpstatOutputParser.this.in);
                br = new BufferedReader(isr);
                String line = null;
                int i = 0;
                double currentUtilization = 0.0;
                ArrayList<String> elements = new ArrayList<String>();
                while ((line = br.readLine()) != null) {
                    if (CPUExecHandler.logger.isLoggable(Level.FINEST)) {
                        CPUExecHandler.logger.finest("Parsing outpt from mpstat\n[" + line + "]");
                    }
                    if (i > 0) {
                        double utilPercent;
                        elements.clear();
                        StringTokenizer st = new StringTokenizer(line, " ");
                        while (st.hasMoreTokens()) {
                            elements.add(st.nextToken());
                        }
                        double cpuIdle = new Double((String)elements.get(15));
                        if (CPUExecHandler.logger.isLoggable(Level.FINEST)) {
                            CPUExecHandler.logger.finest("CPU idle value=" + cpuIdle);
                        }
                        if ((utilPercent = 1.0 - cpuIdle / 100.0) < 0.0) {
                            if (CPUExecHandler.logger.isLoggable(Level.FINEST)) {
                                CPUExecHandler.logger.finest("CPU utilization=" + utilPercent + ", adjust to 0");
                            }
                            utilPercent = 0.0;
                        }
                        if (CPUExecHandler.logger.isLoggable(Level.FINEST)) {
                            CPUExecHandler.logger.finest("CPU utilization percent=" + utilPercent);
                        }
                        currentUtilization = (currentUtilization + utilPercent) / (double)i;
                    }
                    ++i;
                }
                MpstatOutputParser.this.utilization = currentUtilization;
            }
            catch (IOException e) {
                CPUExecHandler.logger.log(Level.WARNING, "Parsing stream from mpstat", e);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    CPUExecHandler.logger.log(Level.WARNING, "Closing BufferedReader", e);
                }
            }
        }
    }
}

