/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.measurable.disk;

import com.sun.jini.config.Config;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import org.jini.rio.core.ResourceCostModel;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.ZeroCostModel;
import org.jini.rio.qos.measurable.MeasurableCapability;
import org.jini.rio.qos.measurable.MeasurableMonitor;
import org.jini.rio.qos.measurable.disk.CalculableDiskSpace;
import org.jini.rio.qos.measurable.disk.DiskSpaceMBean;
import org.jini.rio.qos.measurable.disk.DiskSpaceMonitor;

public class DiskSpace
extends MeasurableCapability
implements DiskSpaceMBean {
    public static final String VIEW = "org.jini.rio.qos.measurable.disk.CalculableDiskSpaceView";
    private int count;
    private double tempUsed;
    private double used;
    private double tempAvailable;
    private double available;
    private double capacity;
    private double utilization;
    private MeasurableMonitor monitor;
    static final String COMPONENT = "org.jini.rio.qos.measurable.disk";
    static Logger logger = Logger.getLogger("org.jini.rio.qos.measurable.disk");

    public DiskSpace(Configuration config) {
        super("DiskSpace", config);
        this.setView(VIEW);
        try {
            ThresholdValues tVals = (ThresholdValues)config.getEntry(COMPONENT, "thresholdValues", ThresholdValues.class, (Object)new ThresholdValues(0.0, 0.99));
            this.setThresholdValues(tVals);
            ResourceCostModel rCostModel = (ResourceCostModel)config.getEntry(COMPONENT, "resourceCost", ResourceCostModel.class, (Object)new ZeroCostModel());
            this.setResourceCostModel(rCostModel);
            this.sampleSize = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"sampleSize", (int)1, (int)1, (int)10);
            this.setSampleSize(this.sampleSize);
            long reportRate = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"reportRate", (long)30000L, (long)5000L, (long)Long.MAX_VALUE);
            this.setPeriod(reportRate);
            this.monitor = (MeasurableMonitor)config.getEntry(COMPONENT, "diskMonitor", MeasurableMonitor.class, (Object)new DiskSpaceMonitor());
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Getting DiskSpace Configuration", e);
        }
    }

    @Override
    public void start() {
        if (this.monitor != null) {
            this.checkValue();
            super.start();
        }
    }

    @Override
    public double getUtilization() {
        return this.utilization;
    }

    @Override
    public double getCapacity() {
        return this.capacity;
    }

    @Override
    public void checkValue() {
        ++this.count;
        if (this.monitor == null) {
            return;
        }
        double[] values = this.monitor.getValues();
        this.tempAvailable += values[0];
        if (!Double.isNaN(values[1]) && values[1] != 0.0) {
            this.tempUsed += values[1];
            if (this.count == this.sampleSize) {
                this.available = this.tempAvailable / (double)this.sampleSize;
                this.used = this.tempUsed / (double)this.sampleSize;
                this.capacity = this.used + this.available;
                this.count = 0;
                this.tempAvailable = 0.0;
                this.tempUsed = 0.0;
                if (this.capacity > 0.0) {
                    this.utilization = this.used / this.capacity;
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("DiskSpace : capacity=" + this.capacity + ", used=" + this.used + ", utilization=" + this.utilization);
            }
            long now = System.currentTimeMillis();
            this.addWatchRecord(new CalculableDiskSpace(this.getId(), this.utilization, now, this.capacity, this.available));
        } else if (logger.isLoggable(Level.FINEST)) {
            String detail = "";
            if (Double.isNaN(values[1])) {
                detail = ", value for used diskspace is NaN";
            }
            if (values[1] == 0.0) {
                detail = ", value for used diskspace is 0";
            }
            String osName = System.getProperty("os.name");
            logger.finest("[" + osName + "] DiskSpace value cannot be processed" + detail);
        }
    }

    public static void main(String[] argv) {
        DiskSpace diskSpace = new DiskSpace((Configuration)EmptyConfiguration.INSTANCE);
        diskSpace.setSampleSize(2);
        System.out.println("\nJVM Version      : " + System.getProperty("java.vm.version"));
        System.out.println("Hardware Arch    : " + System.getProperty("os.arch"));
        System.out.println("Operating System : " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        System.out.println("==================================================");
        diskSpace.start();
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            System.out.println("DiskSpace Utilization : [" + diskSpace.getUtilization() + "]\tCapacity [" + diskSpace.getCapacity() + "]");
        }
    }
}

