/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.measurable.disk;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.qos.measurable.MeasurableMonitor;

public class DiskSpaceMonitor
implements MeasurableMonitor {
    static Logger logger = Logger.getLogger("org.jini.rio.qos.measurable.disk");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getValues() {
        double used = 0.0;
        double available = 0.0;
        String osName = System.getProperty("os.name");
        if (osName != null && !osName.startsWith("Windows")) {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec("df -k");
                DFOutputParser outputParser = new DFOutputParser(process.getInputStream());
                outputParser.start();
                this.waitFor(process, 5000L);
                Thread.sleep(10L);
                used = outputParser.getUsed() * 1024.0;
                available = outputParser.getAvailable() * 1024.0;
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Executing or spawning [df-k]", e);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Executing or spawning [df-k]", e);
            }
            finally {
                if (process != null) {
                    try {
                        process.getErrorStream().close();
                    }
                    catch (Exception e) {}
                    try {
                        process.getInputStream().close();
                    }
                    catch (Exception e) {}
                    try {
                        process.getOutputStream().close();
                    }
                    catch (Exception e) {}
                    try {
                        process.destroy();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return new double[]{available, used};
    }

    @Override
    public double getValue() {
        return 0.0;
    }

    @Override
    public void terminate() {
    }

    boolean waitFor(Process process, long timeout) throws InterruptedException {
        int interval = 200;
        for (long timeWaiting = 0L; timeWaiting < timeout; timeWaiting += 200L) {
            if (!this.isProcessAlive(process)) {
                return true;
            }
            Thread.sleep(200L);
        }
        return false;
    }

    boolean isProcessAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    static class DFOutputParser
    extends Thread {
        InputStream in;
        volatile double used;
        volatile double available;

        public DFOutputParser(InputStream in) {
            this.in = in;
        }

        double getAvailable() {
            return this.available;
        }

        double getUsed() {
            return this.used;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader br = null;
            try {
                String fileSep = System.getProperty("file.separator");
                File root = new File(fileSep);
                ArrayList<String> list = new ArrayList<String>();
                InputStreamReader isr = new InputStreamReader(this.in);
                br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("Filesystem")) continue;
                    StringTokenizer st = new StringTokenizer(line, " ");
                    while (st.hasMoreTokens()) {
                        list.add(st.nextToken());
                    }
                    if (list.size() == 1) continue;
                    String mountPoint = (String)list.get(5);
                    if (root.getCanonicalPath().startsWith(mountPoint)) {
                        this.used = new Double((String)list.get(2));
                        this.available = new Double((String)list.get(3));
                    }
                    list.clear();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

