/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.qos.measurable.memory;

import com.sun.jini.config.Config;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.jini.rio.core.ResourceCostModel;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.ZeroCostModel;
import org.jini.rio.qos.measurable.MeasurableCapability;
import org.jini.rio.qos.measurable.MeasurableMonitor;
import org.jini.rio.qos.measurable.memory.CalculableMemory;
import org.jini.rio.qos.measurable.memory.MemoryMonitor;

public class Memory
extends MeasurableCapability {
    private int count;
    private double tempUtilization;
    private double utilization;
    static final String VIEW = "org.jini.rio.qos.measurable.memory.CalculableMemoryView";
    double totalArena;
    MeasurableMonitor monitor;
    static final String COMPONENT = "org.jini.rio.qos.measurable.memory";
    static Logger logger = Logger.getLogger("org.jini.rio.qos.measurable.memory");

    public Memory(Configuration config) {
        super("Memory", config);
        this.setView(VIEW);
        try {
            ThresholdValues tVals = (ThresholdValues)config.getEntry(COMPONENT, "thresholdValues", ThresholdValues.class, (Object)new ThresholdValues(0.0, 0.99));
            this.setThresholdValues(tVals);
            ResourceCostModel rCostModel = (ResourceCostModel)config.getEntry(COMPONENT, "resourceCost", ResourceCostModel.class, (Object)new ZeroCostModel());
            this.setResourceCostModel(rCostModel);
            this.sampleSize = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"sampleSize", (int)1, (int)1, (int)10);
            this.setSampleSize(this.sampleSize);
            long reportRate = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"reportRate", (long)30000L, (long)5000L, (long)Integer.MAX_VALUE);
            this.setPeriod(reportRate);
            this.totalArena = Runtime.getRuntime().maxMemory();
            this.monitor = (MeasurableMonitor)config.getEntry(COMPONENT, "memoryMonitor", MeasurableMonitor.class, (Object)new MemoryMonitor());
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Getting Memory Configuration", e);
        }
    }

    @Override
    public void start() {
        this.checkValue();
        super.start();
    }

    @Override
    public double getUtilization() {
        return this.utilization;
    }

    @Override
    public void checkValue() {
        ++this.count;
        double[] values = this.monitor.getValues();
        double usedMemory = values[0];
        double totalMemory = values[1];
        if (totalMemory > this.totalArena) {
            this.totalArena = totalMemory;
        }
        double util = usedMemory / totalMemory;
        this.tempUtilization += util;
        if (this.count == this.sampleSize) {
            this.utilization = this.tempUtilization / (double)this.sampleSize;
            this.count = 0;
            this.tempUtilization = 0.0;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Memory : utilization=" + this.utilization);
        }
        long now = System.currentTimeMillis();
        this.addWatchRecord(new CalculableMemory(this.getId(), this.utilization, now, this.totalArena));
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] argv) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

