/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.client;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.entry.Name;
import org.jini.rio.core.FaultDetectionHandler;
import org.jini.rio.core.FaultDetectionListener;
import org.jini.rio.core.ServiceFaultDetectionMonitorDetectedFailureAware;
import org.jini.rio.core.ServiceFaultDetectionMonitorIsAliveAware;
import org.jini.rio.core.ServiceFaultDetectionMonitorSuspectingFailureAware;
import org.jini.rio.core.ServiceFaultDetectionUnhealthySpaceAware;
import org.jini.rio.resources.client.ServiceDiscoveryAdapter;

public abstract class AbstractFaultDetectionHandler
implements FaultDetectionHandler {
    public static final int DEFAULT_INVOCATION_DELAY = 60000;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final long DEFAULT_RETRY_TIMEOUT = 1000L;
    public static final String RETRY_COUNT_KEY = "retryCount";
    public static final String RETRY_TIMEOUT_KEY = "retryTimeout";
    protected Object proxy;
    protected int retryCount = 3;
    protected long retryTimeout = 1000L;
    protected long invocationDelay = 60000L;
    private final List<FaultDetectionListener> listeners = new CopyOnWriteArrayList<FaultDetectionListener>();
    private ServiceID serviceID;
    private LookupCache lCache;
    protected volatile boolean terminating = false;
    private final AtomicBoolean notified = new AtomicBoolean(false);
    protected String[] configArgs;
    protected Configuration config;
    private FDHListener fdhListener;
    protected ServiceMonitor serviceMonitor;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static volatile ScheduledExecutorService executorService;
    private static volatile int totalNumberOfFDH;
    private volatile ScheduledFuture scheduledFuture;
    private static final Object executorMonitor;

    @Override
    public void register(FaultDetectionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregister(FaultDetectionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void monitor(Object proxy, Object id, LookupCache lCache) throws Exception {
        try {
            if (proxy == null) {
                throw new NullPointerException("proxy is null");
            }
            if (id == null) {
                throw new NullPointerException("id is null");
            }
            this.proxy = proxy;
            this.serviceID = (ServiceID)id;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Monitoring Service: [" + this.serviceID + "] using proxy: [" + proxy.getClass() + "]");
            }
            if (lCache != null) {
                this.lCache = lCache;
                this.fdhListener = new FDHListener();
                this.lCache.addListener((ServiceDiscoveryListener)this.fdhListener);
            }
            this.serviceMonitor = this.getServiceMonitor();
            Object object = executorMonitor;
            synchronized (object) {
                if (this.serviceMonitor != null && this.canbeScheduled()) {
                    if (totalNumberOfFDH == 0) {
                        int threadCount = Integer.parseInt(System.getProperty("com.gs.fdh.threadcount", "10"));
                        executorService = Executors.newScheduledThreadPool(threadCount, new MyThreadFactory());
                    }
                    ++totalNumberOfFDH;
                    this.scheduledFuture = executorService.scheduleWithFixedDelay(new ScheduledMonitor(), this.invocationDelay, this.invocationDelay, TimeUnit.MILLISECONDS);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error Monitoring Service", e);
            Thread t = new Thread(new ScheduledMonitorError());
            t.start();
        }
    }

    protected abstract ServiceMonitor getServiceMonitor() throws Exception;

    protected boolean canbeScheduled() {
        return true;
    }

    private synchronized boolean isTerminating() {
        return this.terminating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateAndNotifyListeners() {
        boolean notifyListeners = false;
        AbstractFaultDetectionHandler abstractFaultDetectionHandler = this;
        synchronized (abstractFaultDetectionHandler) {
            if (!this.isTerminating()) {
                this.terminate();
                notifyListeners = true;
            }
        }
        if (notifyListeners) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void terminate() {
        if (this.terminating) {
            return;
        }
        this.terminating = true;
        Object object = executorMonitor;
        synchronized (object) {
            if (this.serviceMonitor != null && this.canbeScheduled()) {
                this.scheduledFuture.cancel(false);
                if (--totalNumberOfFDH <= 0) {
                    totalNumberOfFDH = 0;
                    if (!executorService.isShutdown()) {
                        executorService.shutdown();
                    }
                }
            }
        }
        if (this.lCache != null && this.fdhListener != null) {
            try {
                this.lCache.removeListener((ServiceDiscoveryListener)this.fdhListener);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Exception {0} removing Listener from LookupCache", new Object[]{t.getClass().getName()});
            }
        }
        if (this.serviceMonitor != null) {
            this.serviceMonitor.drop();
        }
    }

    private boolean notifyListenersOfUnhealthy() {
        boolean handledByAllListeners = true;
        FaultDetectionListener[] arrLocal = this.listeners.toArray(new FaultDetectionListener[this.listeners.size()]);
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ServiceFaultDetectionUnhealthySpaceAware listener;
            if (!(arrLocal[i] instanceof ServiceFaultDetectionUnhealthySpaceAware) || (listener = (ServiceFaultDetectionUnhealthySpaceAware)((Object)arrLocal[i])).handleUnhealthy(this.proxy, this.serviceID)) continue;
            handledByAllListeners = false;
        }
        return handledByAllListeners;
    }

    protected void notifyListeners() {
        if (!this.notified.compareAndSet(false, true)) {
            return;
        }
        if (this.serviceMonitor != null) {
            this.serviceMonitor.reportLastError();
        }
        FaultDetectionListener[] arrLocal = this.listeners.toArray(new FaultDetectionListener[this.listeners.size()]);
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            arrLocal[i].serviceFailure(this.proxy, this.serviceID);
            if (!(arrLocal[i] instanceof ServiceFaultDetectionMonitorDetectedFailureAware)) continue;
            ServiceFaultDetectionMonitorDetectedFailureAware listener = (ServiceFaultDetectionMonitorDetectedFailureAware)((Object)arrLocal[i]);
            listener.detectedFailure(this.serviceID);
        }
    }

    private void notifyIsAliveAwareListeners() {
        FaultDetectionListener[] arrLocal = this.listeners.toArray(new FaultDetectionListener[this.listeners.size()]);
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            if (!(arrLocal[i] instanceof ServiceFaultDetectionMonitorIsAliveAware)) continue;
            ServiceFaultDetectionMonitorIsAliveAware listener = (ServiceFaultDetectionMonitorIsAliveAware)((Object)arrLocal[i]);
            listener.isAlive(this.serviceID);
        }
    }

    private void notifySuspectingFailureAwareListeners() {
        FaultDetectionListener[] arrLocal = this.listeners.toArray(new FaultDetectionListener[this.listeners.size()]);
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            if (!(arrLocal[i] instanceof ServiceFaultDetectionMonitorSuspectingFailureAware)) continue;
            ServiceFaultDetectionMonitorSuspectingFailureAware listener = (ServiceFaultDetectionMonitorSuspectingFailureAware)((Object)arrLocal[i]);
            listener.suspectingFailure(this.serviceID);
        }
    }

    protected String getName(Entry[] attrs) {
        for (int i = 0; i < attrs.length; ++i) {
            if (!(attrs[i] instanceof Name)) continue;
            return ((Name)attrs[i]).name;
        }
        return "unknown";
    }

    protected ServiceID getServiceID() {
        return this.serviceID;
    }

    static {
        totalNumberOfFDH = 0;
        executorMonitor = new Object();
    }

    private static class MyThreadFactory
    implements ThreadFactory {
        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Fault Detection Handler");
            thread.setDaemon(true);
            return thread;
        }
    }

    class FDHListener
    extends ServiceDiscoveryAdapter {
        FDHListener() {
        }

        @Override
        public void serviceRemoved(ServiceDiscoveryEvent sdEvent) {
            ServiceItem item = sdEvent.getPreEventServiceItem();
            if (!item.serviceID.equals((Object)AbstractFaultDetectionHandler.this.serviceID)) {
                return;
            }
            if (!AbstractFaultDetectionHandler.this.terminating && AbstractFaultDetectionHandler.this.logger.isLoggable(Level.FINE)) {
                AbstractFaultDetectionHandler.this.logger.fine("Received notification that the service: " + AbstractFaultDetectionHandler.this.serviceMonitor + " has been removed from the lookup-cache");
            }
        }
    }

    public static interface ServiceMonitor {
        public void drop();

        public void reportFirstError();

        public void reportLastError();

        public boolean verify();

        public boolean shouldRetry();
    }

    private class ScheduledRetryMonitor
    implements Runnable {
        private int internalRetryCount;

        private ScheduledRetryMonitor() {
        }

        @Override
        public void run() {
            if (this.shouldStopMonitoring()) {
                AbstractFaultDetectionHandler.this.terminateAndNotifyListeners();
                return;
            }
            boolean verified = AbstractFaultDetectionHandler.this.serviceMonitor.verify();
            if (verified) {
                try {
                    AbstractFaultDetectionHandler.this.notifyIsAliveAwareListeners();
                    AbstractFaultDetectionHandler.this.scheduledFuture.cancel(false);
                    AbstractFaultDetectionHandler.this.scheduledFuture = executorService.scheduleWithFixedDelay(new ScheduledMonitor(), AbstractFaultDetectionHandler.this.invocationDelay, AbstractFaultDetectionHandler.this.invocationDelay, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    AbstractFaultDetectionHandler.this.logger.log(Level.WARNING, "Error Monitoring Service", e);
                    new Thread(new ScheduledMonitorError()).start();
                }
            } else if (AbstractFaultDetectionHandler.this.serviceMonitor.shouldRetry()) {
                ++this.internalRetryCount;
            } else {
                AbstractFaultDetectionHandler.this.scheduledFuture.cancel(false);
                AbstractFaultDetectionHandler.this.scheduledFuture = executorService.scheduleWithFixedDelay(new ScheduledRetryUnhealthyMonitor(Integer.MAX_VALUE), AbstractFaultDetectionHandler.this.retryTimeout, AbstractFaultDetectionHandler.this.retryTimeout, TimeUnit.MILLISECONDS);
            }
        }

        private boolean shouldStopMonitoring() {
            return this.internalRetryCount >= AbstractFaultDetectionHandler.this.retryCount || AbstractFaultDetectionHandler.this.isTerminating();
        }
    }

    private class ScheduledRetryUnhealthyMonitor
    implements Runnable {
        private int retries;

        public ScheduledRetryUnhealthyMonitor(int retries) {
            this.retries = retries;
        }

        @Override
        public void run() {
            if (this.retries == 0 || AbstractFaultDetectionHandler.this.isTerminating()) {
                if (AbstractFaultDetectionHandler.this.logger.isLoggable(Level.FINE)) {
                    AbstractFaultDetectionHandler.this.logger.fine("Terminate fault-detection retries for " + AbstractFaultDetectionHandler.this.serviceMonitor);
                }
                AbstractFaultDetectionHandler.this.terminateAndNotifyListeners();
                return;
            }
            boolean handled = AbstractFaultDetectionHandler.this.notifyListenersOfUnhealthy();
            if (handled) {
                if (AbstractFaultDetectionHandler.this.logger.isLoggable(Level.FINE)) {
                    AbstractFaultDetectionHandler.this.logger.fine("Terminate fault-detection for " + AbstractFaultDetectionHandler.this.serviceMonitor + "; handled unhealthy state");
                }
                AbstractFaultDetectionHandler.this.terminateAndNotifyListeners();
                return;
            }
            boolean verified = AbstractFaultDetectionHandler.this.serviceMonitor.verify();
            if (!verified && AbstractFaultDetectionHandler.this.serviceMonitor.shouldRetry()) {
                if (AbstractFaultDetectionHandler.this.logger.isLoggable(Level.INFO)) {
                    AbstractFaultDetectionHandler.this.logger.info("Terminate fault-detection for " + AbstractFaultDetectionHandler.this.serviceMonitor + "; is unreachable");
                }
                AbstractFaultDetectionHandler.this.terminateAndNotifyListeners();
                return;
            }
            --this.retries;
        }
    }

    public class ScheduledMonitor
    implements Runnable {
        @Override
        public void run() {
            boolean verified = AbstractFaultDetectionHandler.this.serviceMonitor.verify();
            if (verified) {
                return;
            }
            try {
                AbstractFaultDetectionHandler.this.scheduledFuture.cancel(false);
                AbstractFaultDetectionHandler.this.serviceMonitor.reportFirstError();
                AbstractFaultDetectionHandler.this.notifySuspectingFailureAwareListeners();
                if (AbstractFaultDetectionHandler.this.serviceMonitor.shouldRetry()) {
                    AbstractFaultDetectionHandler.this.scheduledFuture = executorService.scheduleWithFixedDelay(new ScheduledRetryMonitor(), AbstractFaultDetectionHandler.this.retryTimeout, AbstractFaultDetectionHandler.this.retryTimeout, TimeUnit.MILLISECONDS);
                } else {
                    AbstractFaultDetectionHandler.this.scheduledFuture = executorService.scheduleWithFixedDelay(new ScheduledRetryUnhealthyMonitor(Integer.MAX_VALUE), AbstractFaultDetectionHandler.this.retryTimeout, AbstractFaultDetectionHandler.this.retryTimeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                AbstractFaultDetectionHandler.this.logger.log(Level.WARNING, "Error Monitoring Service", e);
                new Thread(new ScheduledMonitorError()).start();
            }
        }
    }

    public class ScheduledMonitorError
    implements Runnable {
        @Override
        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                AbstractFaultDetectionHandler.this.logger.log(Level.WARNING, e1.toString(), e1);
            }
            AbstractFaultDetectionHandler.this.notifyListeners();
        }
    }
}

