/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.client;

import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import org.jini.rio.resources.client.AbstractFaultDetectionHandler;

public class AdminFaultDetectionHandler
extends AbstractFaultDetectionHandler {
    public static final String INVOCATION_DELAY_KEY = "invocationDelay";
    private static final String COMPONENT = "org.jini.rio.resources.client.AdminFaultDetectionHandler";
    static Logger logger = Logger.getLogger("org.jini.rio.resources.client.AdminFaultDetectionHandler");

    @Override
    public void setConfiguration(String[] configArgs) {
        if (configArgs == null) {
            throw new NullPointerException("configArgs is null");
        }
        try {
            this.configArgs = new String[configArgs.length];
            System.arraycopy(configArgs, 0, this.configArgs, 0, configArgs.length);
            this.config = ConfigurationProvider.getInstance((String[])configArgs);
            this.invocationDelay = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)INVOCATION_DELAY_KEY, (long)60000L, (long)0L, (long)Long.MAX_VALUE);
            this.retryCount = Config.getIntEntry((Configuration)this.config, (String)COMPONENT, (String)"retryCount", (int)3, (int)0, (int)Integer.MAX_VALUE);
            this.retryTimeout = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)"retryTimeout", (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            if (logger.isLoggable(Level.CONFIG)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("AdminFaultDetectionHandler Properties : ");
                buffer.append("\n invocationDelay= " + this.invocationDelay + ", ");
                buffer.append("\n retry count=" + this.retryCount + ", ");
                buffer.append("\n retry timeout=" + this.retryTimeout);
                buffer.append("\n configArgs: " + Arrays.toString(configArgs));
                logger.config(buffer.toString());
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.SEVERE, "Setting Configuration", e);
        }
    }

    @Override
    protected boolean canbeScheduled() {
        return true;
    }

    @Override
    protected AbstractFaultDetectionHandler.ServiceMonitor getServiceMonitor() throws Exception {
        ServiceAdminManager monitor = null;
        if (this.proxy instanceof Administrable) {
            ((Administrable)this.proxy).getAdmin();
            monitor = new ServiceAdminManager();
        }
        return monitor;
    }

    class ServiceAdminManager
    implements AbstractFaultDetectionHandler.ServiceMonitor {
        ServiceAdminManager() {
        }

        @Override
        public void drop() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Dropping monitor for service: [" + AdminFaultDetectionHandler.this.getServiceID() + "]");
            }
        }

        @Override
        public void reportFirstError() {
        }

        @Override
        public void reportLastError() {
        }

        @Override
        public boolean verify() {
            boolean verified;
            block6: {
                verified = false;
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Requesting getAdmin() on service: [" + AdminFaultDetectionHandler.this.getServiceID() + "]");
                    }
                    ((Administrable)AdminFaultDetectionHandler.this.proxy).getAdmin();
                    verified = true;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("getAdmin() successfully verified on service: [" + AdminFaultDetectionHandler.this.getServiceID() + "]");
                    }
                }
                catch (RemoteException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "RemoteException reaching service: [" + AdminFaultDetectionHandler.this.getServiceID() + "] service cannot be reached", e);
                    }
                }
                catch (Throwable t) {
                    int category = ThrowableConstants.retryable((Throwable)t);
                    if (category != 1 && category != 2 || !logger.isLoggable(Level.FINE)) break block6;
                    logger.log(Level.FINE, "Unrecoverable Exception invoking getAdmin()", t);
                }
            }
            return verified;
        }

        @Override
        public boolean shouldRetry() {
            return true;
        }
    }
}

