/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.client;

import com.gigaspaces.time.SystemTime;
import com.sun.jini.config.Config;
import com.sun.jini.config.ConfigUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class HeartbeatClient {
    private static final long DEFAULT_HEARTBEAT_PERIOD = 30000L;
    public static final String HEARTBEAT_SERVER_KEY = "heartbeatServer";
    public static final String HEARTBEAT_PERIOD_KEY = "heartbeatPeriod";
    private final Uuid uuid;
    private final Timer taskTimer;
    private static final String COMPONENT = "org.jini.rio.resources.client.HeartbeatFaultDetectionHandler";
    static Logger logger = Logger.getLogger("org.jini.rio.resources.client.HeartbeatFaultDetectionHandler");

    public HeartbeatClient(Uuid uuid) {
        this.uuid = uuid;
        this.taskTimer = new Timer(true);
    }

    public void terminate() {
        this.taskTimer.cancel();
    }

    public void addHeartbeatServer(String[] configArgs) throws ConfigurationException {
        Configuration config = ConfigurationProvider.getInstance((String[])configArgs);
        String heartbeatServer = (String)config.getEntry(COMPONENT, HEARTBEAT_SERVER_KEY, String.class);
        int port = 0;
        int ndx = heartbeatServer.indexOf(58);
        if (ndx == -1) {
            throw new ConfigurationException("heartbeatServer wrong format, no port");
        }
        String portString = heartbeatServer.substring(ndx + 1);
        heartbeatServer = heartbeatServer.substring(0, ndx);
        port = new Integer(portString);
        long heartbeatPeriod = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)HEARTBEAT_PERIOD_KEY, (long)30000L, (long)0L, (long)Long.MAX_VALUE);
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("HeartbeatClient Properties : ");
            buffer.append("heartbeatPeriod=" + heartbeatPeriod + ", ");
            buffer.append("heartbeatServer=" + heartbeatServer + ", ");
            buffer.append("port=" + port);
            logger.finest(buffer.toString());
        }
        try {
            InetAddress address = InetAddress.getByName(heartbeatServer);
            this.taskTimer.scheduleAtFixedRate((TimerTask)new HeartbeatTask(address, port), 1000L, heartbeatPeriod);
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException("heartbeatServer [" + heartbeatServer + "] Unknown host", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            ServerSocket serverSocket = new ServerSocket(7777);
            HeartbeatClient heartbeat = new HeartbeatClient(UuidFactory.generate());
            String heartbeatServer = "org.jini.rio.resources.client.HeartbeatFaultDetectionHandler.heartbeatServer=\"localhost:7777\"";
            String heartbeatPeriod = "org.jini.rio.resources.client.HeartbeatFaultDetectionHandler.heartbeatPeriod=5000";
            String[] configArgs = new String[]{"-", ConfigUtil.concat((Object[])new Object[]{heartbeatServer}), ConfigUtil.concat((Object[])new Object[]{heartbeatPeriod})};
            heartbeat.addHeartbeatServer(configArgs);
            long lastReceipt = SystemTime.timeMillis();
            while (true) {
                Socket socket = serverSocket.accept();
                long now = SystemTime.timeMillis();
                BufferedInputStream bis = new BufferedInputStream(socket.getInputStream(), 256);
                StringBuffer buf = new StringBuffer(80);
                while (bis.available() > 0) {
                    System.out.println("bytes available : " + bis.available());
                    byte[] data = new byte[bis.available()];
                    bis.read(data);
                    buf.append(new String(data));
                }
                System.out.println("heartbeat from : " + buf.toString().trim() + ", period [" + (now - lastReceipt) + "]");
                lastReceipt = now;
                socket.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    class HeartbeatTask
    extends TimerTask {
        InetAddress address;
        int port;

        HeartbeatTask(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        @Override
        public void run() {
            try {
                Socket socket = new Socket(this.address, this.port);
                socket.getOutputStream().write(HeartbeatClient.this.uuid.toString().getBytes());
                socket.close();
            }
            catch (NoRouteToHostException e) {
                logger.warning(e.getClass().getName() + " Heartbeat server [" + this.address.getHostAddress() + ":" + this.port + "] cannot be reached, cancel HeartbeatTask");
                this.cancel();
            }
            catch (IOException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(e.getClass().getName() + " Heartbeat server communication dropped, cancel HeartbeatTask to [" + this.address.getHostAddress() + ":" + this.port + "]");
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Heartbeat server communication dropped, cancel HeartbeatTask to [" + this.address.getHostAddress() + ":" + this.port + "]", e);
                }
                this.cancel();
            }
        }
    }
}

