/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.client;

import com.gigaspaces.start.SystemInfo;
import com.sun.jini.config.Config;
import com.sun.jini.config.ConfigUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.lookup.LookupCache;
import org.jini.rio.core.MonitorableService;
import org.jini.rio.resources.client.AbstractFaultDetectionHandler;

public class HeartbeatFaultDetectionHandler
extends AbstractFaultDetectionHandler {
    private static final long DEFAULT_HEARTBEAT_PERIOD = 30000L;
    private static final long DEFAULT_HEARTBEAT_GRACE_PERIOD = 1000L;
    public static final String SERVER_SOCKET_KEY = "serverSocket";
    public static final String HEARTBEAT_PERIOD_KEY = "heartbeatPeriod";
    public static final String HEARTBEAT_GRACE_PERIOD_KEY = "heartbeatGracePeriod";
    private long heartbeatPeriod = 30000L;
    private long heartbeatGracePeriod = 1000L;
    private ServerSocket serverSocket;
    private HeartbeatManager heartbeatManager;
    private String[] monitorableConfig;
    private Timer taskTimer;
    private static final String COMPONENT = "org.jini.rio.resources.client.HeartbeatFaultDetectionHandler";
    static Logger logger = Logger.getLogger("org.jini.rio.resources.client.HeartbeatFaultDetectionHandler");

    @Override
    public void setConfiguration(String[] configArgs) {
        if (configArgs == null) {
            throw new NullPointerException("configArgs is null");
        }
        try {
            this.config = ConfigurationProvider.getInstance((String[])configArgs);
            this.heartbeatPeriod = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)HEARTBEAT_PERIOD_KEY, (long)30000L, (long)0L, (long)Long.MAX_VALUE);
            this.heartbeatGracePeriod = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)HEARTBEAT_GRACE_PERIOD_KEY, (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            ServerSocket defaultServerSocket = new ServerSocket(0, 50, SystemInfo.singleton().network().getHost());
            this.serverSocket = (ServerSocket)Config.getNonNullEntry((Configuration)this.config, (String)COMPONENT, (String)SERVER_SOCKET_KEY, ServerSocket.class, (Object)defaultServerSocket);
            if (defaultServerSocket.getLocalPort() != this.serverSocket.getLocalPort()) {
                defaultServerSocket.close();
            }
            String hostAddress = this.serverSocket.getInetAddress().getHostAddress();
            int port = this.serverSocket.getLocalPort();
            this.monitorableConfig = new String[configArgs.length + 1];
            System.arraycopy(configArgs, 0, this.monitorableConfig, 0, configArgs.length);
            String configEntry = "org.jini.rio.resources.client.HeartbeatFaultDetectionHandler.heartbeatServer=\"" + hostAddress + ":" + port + "\"";
            this.monitorableConfig[configArgs.length] = ConfigUtil.concat((Object[])new Object[]{configEntry});
            if (logger.isLoggable(Level.CONFIG)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("HeartbeatFaultDetectionHandler Properties : ");
                buffer.append("heartbeatPeriod=" + this.heartbeatPeriod + ", ");
                buffer.append("heartbeatGracePeriod=" + this.heartbeatGracePeriod + ", ");
                buffer.append("serverSocket=" + this.serverSocket + ", ");
                buffer.append("heartbeatServer=" + hostAddress + ":" + port);
                logger.config(buffer.toString());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Setting Configuration", e);
        }
    }

    @Override
    public void monitor(Object proxy, Object id, LookupCache lCache) throws Exception {
        this.taskTimer = new Timer(true);
        super.monitor(proxy, id, lCache);
    }

    @Override
    protected boolean canbeScheduled() {
        return false;
    }

    @Override
    protected AbstractFaultDetectionHandler.ServiceMonitor getServiceMonitor() throws Exception {
        if (this.proxy instanceof MonitorableService) {
            if (this.serverSocket != null) {
                this.heartbeatManager = new HeartbeatManager();
                MonitorableService service = (MonitorableService)this.proxy;
                service.startHeartbeat(this.monitorableConfig);
            } else {
                logger.warning("No ServerSocket, unable to create HeartbeatManager");
            }
        } else {
            logger.info("Service [" + this.proxy.getClass().getName() + "] not an instanceof " + MonitorableService.class.getName() + ", ServiceRegistrar.TRANSITION_MATCH_NOMATCH transitions will only be monitored");
        }
        return this.heartbeatManager;
    }

    @Override
    public void terminate() {
        super.terminate();
        if (this.taskTimer != null) {
            this.taskTimer.cancel();
            this.taskTimer = null;
        }
    }

    class HeartbeatTimeoutTask
    extends TimerTask {
        boolean retry;
        String remoteAddress;

        HeartbeatTimeoutTask(boolean retry) {
            this.retry = retry;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            long period = now - ((HeartbeatFaultDetectionHandler)HeartbeatFaultDetectionHandler.this).heartbeatManager.lastHeartbeat;
            if (period > HeartbeatFaultDetectionHandler.this.heartbeatPeriod + HeartbeatFaultDetectionHandler.this.heartbeatGracePeriod) {
                if (!this.retry) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Heartbeat period exceeded, schedule follow-up task");
                    }
                    HeartbeatTimeoutTask task = new HeartbeatTimeoutTask(true);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("HeartbeatTimeoutTask: schedule heartbeat timeout task in [" + HeartbeatFaultDetectionHandler.this.heartbeatPeriod + "] millis");
                    }
                    HeartbeatFaultDetectionHandler.this.taskTimer.schedule((TimerTask)task, new Date(now + HeartbeatFaultDetectionHandler.this.heartbeatPeriod));
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        String s = this.remoteAddress == null ? "" : " at " + this.remoteAddress;
                        logger.fine("Service" + s + " is ambiguous, assume the worst");
                    }
                    if (!HeartbeatFaultDetectionHandler.this.terminating) {
                        HeartbeatFaultDetectionHandler.this.heartbeatManager.drop();
                        HeartbeatFaultDetectionHandler.this.notifyListeners();
                        this.cancel();
                        HeartbeatFaultDetectionHandler.this.terminate();
                    }
                }
            } else if (logger.isLoggable(Level.FINEST)) {
                String s = this.remoteAddress == null ? "" : "from " + this.remoteAddress;
                logger.finest("Heartbeat within period " + s);
            }
        }
    }

    class HeartbeatManager
    extends Thread
    implements AbstractFaultDetectionHandler.ServiceMonitor {
        boolean keepAlive;
        long lastHeartbeat;

        HeartbeatManager() {
            super("HeartbeatManager:" + HeartbeatFaultDetectionHandler.this.proxy.getClass().getName() + ":" + System.currentTimeMillis());
            this.keepAlive = true;
            this.setDaemon(true);
            this.start();
        }

        @Override
        public boolean verify() {
            if (!this.keepAlive) {
                return false;
            }
            boolean verified = false;
            try {
                MonitorableService service = (MonitorableService)HeartbeatFaultDetectionHandler.this.proxy;
                service.ping();
                verified = true;
            }
            catch (RemoteException e) {
                logger.finer("RemoteException reaching service, service cannot be reached");
            }
            return verified;
        }

        @Override
        public void drop() {
            this.keepAlive = false;
            this.interrupt();
            try {
                HeartbeatFaultDetectionHandler.this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Dropping monitor for service: [" + HeartbeatFaultDetectionHandler.this.getServiceID() + "]");
            }
        }

        @Override
        public void reportFirstError() {
        }

        @Override
        public void reportLastError() {
        }

        @Override
        public void run() {
            long now;
            this.lastHeartbeat = now = System.currentTimeMillis();
            HeartbeatTimeoutTask hbTask = new HeartbeatTimeoutTask(false);
            HeartbeatFaultDetectionHandler.this.taskTimer.scheduleAtFixedRate((TimerTask)hbTask, new Date(now + HeartbeatFaultDetectionHandler.this.heartbeatPeriod), HeartbeatFaultDetectionHandler.this.heartbeatPeriod);
            while (!HeartbeatManager.interrupted()) {
                if (!this.keepAlive) {
                    return;
                }
                try {
                    Socket socket = HeartbeatFaultDetectionHandler.this.serverSocket.accept();
                    this.lastHeartbeat = now = System.currentTimeMillis();
                    if (logger.isLoggable(Level.FINEST)) {
                        String remoteAddr;
                        BufferedInputStream bis = new BufferedInputStream(socket.getInputStream(), 256);
                        StringBuffer buf = new StringBuffer(80);
                        while (bis.available() > 0) {
                            byte[] data = new byte[bis.available()];
                            bis.read(data);
                            buf.append(new String(data));
                        }
                        InetAddress rAddr = socket.getInetAddress();
                        String string = remoteAddr = rAddr == null ? "<unknown>" : rAddr.getHostAddress();
                        if (rAddr != null) {
                            hbTask.remoteAddress = remoteAddr;
                        }
                        logger.finest("Received heartbeat from host=" + remoteAddr + ", ID=" + buf.toString().trim());
                    }
                    socket.close();
                }
                catch (SocketException e) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("ServerSocket closed, leave thread");
                    }
                    this.drop();
                    HeartbeatFaultDetectionHandler.this.terminate();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "ServerSocket IOException", e);
                }
            }
        }

        @Override
        public boolean shouldRetry() {
            return true;
        }
    }
}

