/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.client;

import com.j_spaces.core.jini.SharedDiscoveryManagement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupGroups;
import net.jini.lookup.entry.Name;
import org.jini.rio.core.AssociationDescriptor;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.ServiceElement;

public class JiniClient {
    public static final String GROUPS_PROPERTY_NAME = "org.jini.rio.groups";
    public static final String LOCATOR_PROPERTY_NAME = "org.jini.rio.jini.lookup.locator";
    private DiscoveryManagement discoverer;
    public Listener listener;
    private List regArray;
    private String[] groups;
    private LookupLocator[] locators;
    private boolean createdDiscoverer;
    private static Logger logger = Logger.getLogger("org.jini.rio.resources.client");

    public JiniClient() throws Exception {
        this(null);
    }

    public JiniClient(DiscoveryManagement dm) throws Exception {
        block9: {
            String locatorURL;
            block11: {
                StringTokenizer st;
                block12: {
                    block13: {
                        String gAttr;
                        block10: {
                            block8: {
                                this.discoverer = null;
                                this.listener = null;
                                this.groups = null;
                                this.locators = null;
                                this.createdDiscoverer = false;
                                this.regArray = Collections.synchronizedList(new ArrayList());
                                this.listener = new Listener();
                                if (dm == null) break block8;
                                this.discoverer = dm;
                                dm.addDiscoveryListener((DiscoveryListener)this.listener);
                                break block9;
                            }
                            gAttr = System.getProperty(GROUPS_PROPERTY_NAME);
                            if (gAttr != null) break block10;
                            this.groups = LookupGroups.none();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Set groups to NO_GROUPS");
                            }
                            break block11;
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Set groups to [" + gAttr + "]");
                        }
                        st = new StringTokenizer(gAttr, " \t\n\r\f,");
                        this.groups = new String[st.countTokens()];
                        if (this.groups.length != 1) break block12;
                        this.groups[0] = st.nextToken();
                        if (!this.groups[0].equals("all")) break block13;
                        this.groups = LookupGroups.all();
                        break block11;
                    }
                    if (!this.groups[0].equals("public")) break block11;
                    this.groups[0] = "";
                    break block11;
                }
                int i = 0;
                while (st.hasMoreTokens()) {
                    String g = st.nextToken();
                    if (g.equals("public")) {
                        g = "";
                    }
                    this.groups[i] = g;
                    ++i;
                }
            }
            if ((locatorURL = System.getProperty(LOCATOR_PROPERTY_NAME)) != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Use unicast discovery");
                }
                StringTokenizer st = new StringTokenizer(locatorURL, " \t\n\r\f,");
                LinkedList<LookupLocator> list = new LinkedList<LookupLocator>();
                while (st.hasMoreTokens()) {
                    String locator = st.nextToken();
                    list.add(new LookupLocator(locator));
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Add locator : " + locator);
                }
                this.locators = list.toArray(new LookupLocator[list.size()]);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting discovery process...");
            }
            this.discoverer = SharedDiscoveryManagement.getLookupDiscoveryManager((String[])this.groups, (LookupLocator[])this.locators, (DiscoveryListener)this.listener);
            this.createdDiscoverer = true;
        }
    }

    public static String[] transformGroupNames(String[] groups) {
        String[] adjustedGroups = groups;
        if (groups == null || groups.length == 0) {
            adjustedGroups = LookupGroups.none();
        }
        if (adjustedGroups != null && adjustedGroups.length > 0) {
            if (adjustedGroups.length == 1 && adjustedGroups[0].equals("all")) {
                adjustedGroups = LookupGroups.all();
            } else {
                for (int i = 0; i < adjustedGroups.length; ++i) {
                    if (!adjustedGroups[i].equals("public")) continue;
                    adjustedGroups[i] = "";
                }
            }
        }
        return adjustedGroups;
    }

    public static ServiceTemplate getServiceTemplate(ServiceElement sElem) throws Exception {
        return JiniClient.getServiceTemplate(sElem, null);
    }

    public static ServiceTemplate getServiceTemplate(ServiceElement sElem, ClassLoader cl) throws Exception {
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        ServiceTemplate template = null;
        if (cl == null) {
            final Thread currentThread = Thread.currentThread();
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return currentThread.getContextClassLoader();
                }
            });
        }
        ClassBundle[] eBundles = sElem.getExportBundles();
        Class[] interfaces = new Class[eBundles.length];
        for (int i = 0; i < eBundles.length; ++i) {
            try {
                interfaces[i] = Class.forName(eBundles[i].getClassName(), false, cl);
                continue;
            }
            catch (ClassNotFoundException e) {
                interfaces[i] = eBundles[i].loadClass();
            }
        }
        template = sElem.getMatchOnName() ? new ServiceTemplate(null, interfaces, new Entry[]{new Name(sElem.getName())}) : new ServiceTemplate(null, interfaces, null);
        return template;
    }

    public static DiscoveryManagement getDiscoveryManagement(ServiceElement sElem) throws IOException {
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        return SharedDiscoveryManagement.getLookupDiscoveryManager((String[])sElem.getServiceBeanConfig().getGroups(), (LookupLocator[])sElem.getServiceBeanConfig().getLocators(), null);
    }

    public static ServiceTemplate getServiceTemplate(AssociationDescriptor aDesc) throws Exception {
        return JiniClient.getServiceTemplate(aDesc, null);
    }

    public static ServiceTemplate getServiceTemplate(AssociationDescriptor aDesc, ClassLoader cl) throws Exception {
        if (aDesc == null) {
            throw new NullPointerException("aDesc is null");
        }
        ServiceTemplate template = null;
        String[] iNames = aDesc.getInterfaceNames();
        Class[] interfaces = new Class[iNames.length];
        if (cl == null) {
            final Thread currentThread = Thread.currentThread();
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return currentThread.getContextClassLoader();
                }
            });
        }
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = Class.forName(iNames[i], false, cl);
        }
        template = aDesc.matchOnName() ? new ServiceTemplate(null, interfaces, new Entry[]{new Name(aDesc.getName())}) : new ServiceTemplate(null, interfaces, null);
        return template;
    }

    public DiscoveryManagement getDiscoveryManager() {
        return this.discoverer;
    }

    public ServiceRegistrar[] getRegistrars() {
        return this.getServiceRegistrars();
    }

    public void addLocator(String locator) throws MalformedURLException {
        if (this.discoverer instanceof DiscoveryLocatorManagement) {
            ((DiscoveryLocatorManagement)this.discoverer).addLocators(new LookupLocator[]{new LookupLocator(locator)});
        }
    }

    public void addLocator(String host, int port) {
        if (this.discoverer instanceof DiscoveryLocatorManagement) {
            ((DiscoveryLocatorManagement)this.discoverer).addLocators(new LookupLocator[]{new LookupLocator(host, port)});
        }
    }

    public LookupLocator[] getLocators() {
        if (this.discoverer instanceof DiscoveryLocatorManagement) {
            return ((DiscoveryLocatorManagement)this.discoverer).getLocators();
        }
        return new LookupLocator[0];
    }

    public void removeLocators(LookupLocator[] locators) {
        if (this.discoverer instanceof DiscoveryLocatorManagement) {
            ((DiscoveryLocatorManagement)this.discoverer).removeLocators(locators);
        }
    }

    public void addRegistrarGroups(String[] gAdd) throws IOException {
        if (this.discoverer instanceof DiscoveryGroupManagement) {
            ((DiscoveryGroupManagement)this.discoverer).addGroups(gAdd);
        }
    }

    public String[] getRegistrarGroups() {
        try {
            return ((DiscoveryGroupManagement)this.discoverer).getGroups();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Getting Registrar Groups", e);
            return new String[0];
        }
    }

    public void removeRegistrarGroups(String[] gRemove) {
        if (this.discoverer instanceof DiscoveryGroupManagement) {
            ((DiscoveryGroupManagement)this.discoverer).removeGroups(gRemove);
        }
    }

    public void discardRegistrar(ServiceRegistrar registrar) {
        this.discoverer.discard(registrar);
    }

    public void terminate() {
        if (this.createdDiscoverer) {
            this.stopDiscoverer();
        }
        this.regArray.clear();
    }

    ServiceRegistrar[] getServiceRegistrars() {
        return this.discoverer.getRegistrars();
    }

    void stopDiscoverer() {
        if (this.listener != null) {
            if (this.discoverer != null) {
                this.discoverer.removeDiscoveryListener((DiscoveryListener)this.listener);
            }
            this.listener = null;
        }
        if (this.discoverer != null) {
            this.discoverer.terminate();
            this.discoverer = null;
        }
    }

    public class Listener
    implements DiscoveryListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent de) {
            try {
                ServiceRegistrar[] registrars = de.getRegistrars();
                for (int i = 0; i < registrars.length; ++i) {
                    if (logger.isLoggable(Level.FINE) && JiniClient.this.createdDiscoverer) {
                        LookupLocator lookup = registrars[i].getLocator();
                        String host = lookup.getHost();
                        logger.fine("Discovered JLS on host [" + host + "]");
                    }
                    JiniClient.this.regArray.add(registrars[i]);
                }
                Listener listener = this;
                synchronized (listener) {
                    this.notifyAll();
                }
            }
            catch (RemoteException e) {
                logger.log(Level.SEVERE, "Discovered ServiceRegistrar", e);
            }
        }

        public void discarded(DiscoveryEvent dEvent) {
            ServiceRegistrar[] registrars = dEvent.getRegistrars();
            block2: for (int i = 0; i < registrars.length; ++i) {
                for (ServiceRegistrar r : JiniClient.this.regArray) {
                    if (!registrars[i].equals(r)) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        try {
                            LookupLocator lookup = registrars[i].getLocator();
                            String host = lookup.getHost();
                            logger.fine("Discarded JLS on host [" + host + "]");
                        }
                        catch (RemoteException e) {
                            logger.log(Level.SEVERE, "Getting LookupLocator during discarded notification", e);
                        }
                    }
                    JiniClient.this.regArray.remove(JiniClient.this.regArray.indexOf(r));
                    continue block2;
                }
            }
        }
    }
}

