/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.client;

import com.j_spaces.core.jini.SharedDiscoveryManagement;
import com.j_spaces.core.jini.SharedLeaseRenewalManager;
import com.sun.jini.config.Config;
import com.sun.jini.lookup.entry.LookupAttributes;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupGroups;
import net.jini.lookup.BackwardsServiceDiscoveryManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceItemFilter;
import org.jini.rio.resources.client.OpStringFilter;

public class LookupCachePool {
    private Vector pool = new Vector();
    Timer taskTimer = new Timer(true);
    private static final long DEFAULT_CACHE_TIMEOUT = 60000L;
    private long cacheTimeout;
    private static final String COMPONENT = "org.jini.rio.resources.client.LookupCachePool";
    private static final Logger logger = Logger.getLogger("org.jini.rio.resources.client.LookupCachePool");
    private static Configuration config;
    private static LookupCachePool singleton;

    private LookupCachePool() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Create new LookupCachePool");
        }
    }

    public static synchronized LookupCachePool getInstance() {
        return singleton;
    }

    public void setConfiguration(Configuration conf) {
        config = conf;
        if (logger.isLoggable(Level.FINE)) {
            if (config == null) {
                logger.fine("Set null configuration for LookupCachePool");
            } else {
                logger.log(Level.FINE, "Set configuration for LookupCachePool {0}", new Object[]{config});
            }
        }
        try {
            this.cacheTimeout = Config.getLongEntry((Configuration)conf, (String)COMPONENT, (String)"cacheTimeout", (long)60000L, (long)5000L, (long)Long.MAX_VALUE);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "getting cacheTimeout", e);
            this.cacheTimeout = 60000L;
        }
    }

    public LookupCache getLookupCache(String sharedName, String[] groups, LookupLocator[] locators, ServiceTemplate template) throws IOException, ConfigurationException {
        if (template == null) {
            throw new NullPointerException("template is null");
        }
        SDMWrapper sdmWrapper = this.getSDMWrapper(sharedName, groups, locators);
        return sdmWrapper.getLookupCache(template);
    }

    public void terminate() {
        Enumeration en = this.pool.elements();
        while (en.hasMoreElements()) {
            SDMWrapper sdmWrapper = (SDMWrapper)en.nextElement();
            sdmWrapper.sdm.terminate();
        }
        if (this.taskTimer != null) {
            this.taskTimer.cancel();
        }
        this.taskTimer = null;
        this.pool.clear();
        this.pool = null;
        singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SDMWrapper getSDMWrapper(String sharedName, String[] groupsToMatch, LookupLocator[] locatorsToMatch) throws IOException, ConfigurationException {
        SDMWrapper sdmWrapper = null;
        Vector vector = this.pool;
        synchronized (vector) {
            Enumeration en = this.pool.elements();
            while (en.hasMoreElements()) {
                SDMWrapper wrapper = (SDMWrapper)en.nextElement();
                if (!wrapper.namesMatch(sharedName) || !wrapper.groupsMatch(groupsToMatch) || !wrapper.locatorsMatch(locatorsToMatch)) continue;
                sdmWrapper = wrapper;
                break;
            }
        }
        if (sdmWrapper == null) {
            config = config == null ? EmptyConfiguration.INSTANCE : config;
            BackwardsServiceDiscoveryManager sdm = new BackwardsServiceDiscoveryManager((DiscoveryManagement)SharedDiscoveryManagement.getLookupDiscoveryManager((String[])groupsToMatch, (LookupLocator[])locatorsToMatch, null), SharedLeaseRenewalManager.getLeaseRenewalManager(), config);
            sdmWrapper = new SDMWrapper(sharedName, sdm, groupsToMatch, locatorsToMatch);
            this.pool.add(sdmWrapper);
        }
        return sdmWrapper;
    }

    void scheduleCacheTimeout(SharedLookupCache cache) {
        long now = System.currentTimeMillis();
        this.taskTimer.schedule((TimerTask)new CacheTimeout(cache), new Date(now + this.cacheTimeout));
    }

    public static boolean attributesMatch(Entry[] attr1, Entry[] attr2) {
        if (attr1 == null && attr2 == null) {
            return true;
        }
        if (attr1 == null || attr2 == null) {
            return false;
        }
        return LookupAttributes.equal((Entry[])attr1, (Entry[])attr2);
    }

    public static boolean serviceIDsMatch(ServiceID sid1, ServiceID sid2) {
        if (sid1 == null && sid2 == null) {
            return true;
        }
        if (sid1 == null || sid2 == null) {
            return false;
        }
        return sid1.equals((Object)sid2);
    }

    public static boolean serviceTypesMatch(Class[] types1, Class[] types2) {
        if (types1 == null && types2 == null) {
            return true;
        }
        if (types1 == null || types2 == null) {
            return false;
        }
        if (types1.length == types2.length) {
            int matches = 0;
            for (int i = 0; i < types1.length; ++i) {
                for (int j = 0; j < types2.length; ++j) {
                    if (!types1[i].getName().equals(types2[j].getName())) continue;
                    ++matches;
                }
            }
            if (matches == types1.length) {
                return true;
            }
        }
        return false;
    }

    static {
        singleton = new LookupCachePool();
    }

    static class CacheTimeout
    extends TimerTask {
        SharedLookupCache cache;

        CacheTimeout(SharedLookupCache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            this.cache.terminate();
        }
    }

    public class SharedLookupCache
    implements LookupCache {
        LookupCache lCache;
        private final ServiceTemplate template;
        private int refCounter;
        private final SDMWrapper sdmWrapper;
        boolean terminated = false;

        public SharedLookupCache(LookupCache lCache, ServiceTemplate template, SDMWrapper sdmWrapper) {
            this.lCache = lCache;
            this.template = template;
            this.sdmWrapper = sdmWrapper;
        }

        private ServiceTemplate getServiceTemplate() {
            return this.template;
        }

        public ServiceItem lookup(ServiceItemFilter arg0) {
            return this.lCache.lookup(arg0);
        }

        public ServiceItem[] lookup(ServiceItemFilter arg0, int arg1) {
            return this.lCache.lookup(arg0, arg1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(ServiceDiscoveryListener arg0) {
            SharedLookupCache sharedLookupCache = this;
            synchronized (sharedLookupCache) {
                ++this.refCounter;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("LookupCache refCounter : " + this.refCounter);
                }
            }
            this.lCache.addListener(arg0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(ServiceDiscoveryListener arg0) {
            SharedLookupCache sharedLookupCache = this;
            synchronized (sharedLookupCache) {
                if (!this.terminated) {
                    this.lCache.removeListener(arg0);
                    --this.refCounter;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "LCache={0} refCounter={1}", new Object[]{this.lCache.toString(), Integer.toString(this.refCounter)});
                }
                if (this.refCounter == 0) {
                    LookupCachePool.this.scheduleCacheTimeout(this);
                }
            }
        }

        public void discard(Object arg0) {
            this.lCache.discard(arg0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            if (this.refCounter == 0) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "LCache={0} terminated", new Object[]{this.lCache.toString()});
                }
                SharedLookupCache sharedLookupCache = this;
                synchronized (sharedLookupCache) {
                    this.terminated = true;
                    this.lCache.terminate();
                }
                this.sdmWrapper.removeCache(this);
            }
        }

        public boolean isInitialized() {
            return this.lCache.isInitialized();
        }
    }

    class SDMWrapper {
        String sharedName;
        BackwardsServiceDiscoveryManager sdm;
        String[] groups;
        LookupLocator[] locators;
        Hashtable cacheTable = new Hashtable();

        SDMWrapper(String sharedName, BackwardsServiceDiscoveryManager sdm, String[] groups, LookupLocator[] locators) {
            this.sharedName = sharedName;
            this.sdm = sdm;
            if (groups != null) {
                this.groups = new String[groups.length];
                System.arraycopy(groups, 0, this.groups, 0, this.groups.length);
            }
            this.locators = new LookupLocator[locators.length];
            System.arraycopy(locators, 0, this.locators, 0, this.locators.length);
        }

        void removeCache(SharedLookupCache lCache) {
            ServiceTemplate templateToMatch = lCache.getServiceTemplate();
            Enumeration en = this.cacheTable.keys();
            while (en.hasMoreElements()) {
                ServiceTemplate template = (ServiceTemplate)en.nextElement();
                if (!this.templatesMatch(template, templateToMatch)) continue;
                this.cacheTable.remove(templateToMatch);
                break;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("removeCache(), cacheTable.size()==" + this.cacheTable.size());
            }
            if (this.cacheTable.size() == 0) {
                block5: {
                    try {
                        this.sdm.terminate();
                    }
                    catch (IllegalStateException e) {
                        if (!logger.isLoggable(Level.FINEST)) break block5;
                        logger.log(Level.FINEST, "Terminating SDM", e);
                    }
                }
                LookupCachePool.this.pool.remove(this);
            }
        }

        boolean namesMatch(String name) {
            if (this.sharedName == null && name == null) {
                return true;
            }
            if (this.sharedName == null) {
                return false;
            }
            if (name == null) {
                return false;
            }
            return this.sharedName.equals(name);
        }

        boolean groupsMatch(String[] groupsToMatch) {
            if (groupsToMatch == LookupGroups.all() && this.groups == LookupGroups.all()) {
                return true;
            }
            if (groupsToMatch == LookupGroups.all() || this.groups == LookupGroups.all()) {
                return false;
            }
            if (groupsToMatch.length == this.groups.length) {
                int matches = 0;
                for (int i = 0; i < groupsToMatch.length; ++i) {
                    if (!groupsToMatch[i].equals(this.groups[i])) continue;
                    ++matches;
                }
                if (matches == groupsToMatch.length) {
                    return true;
                }
            }
            return false;
        }

        boolean locatorsMatch(LookupLocator[] locatorsToMatch) {
            boolean matched = false;
            if (locatorsToMatch == null && this.locators == null) {
                return true;
            }
            if (locatorsToMatch == null && this.locators != null && this.locators.length == 0) {
                return true;
            }
            if (locatorsToMatch != null && this.locators != null && locatorsToMatch.length == this.locators.length) {
                int matches = 0;
                for (int i = 0; i < locatorsToMatch.length; ++i) {
                    if (!locatorsToMatch[i].equals((Object)this.locators[i])) continue;
                    ++matches;
                }
                if (matches == locatorsToMatch.length) {
                    matched = true;
                }
            }
            return matched;
        }

        LookupCache getLookupCache(ServiceTemplate templateToMatch) throws IOException {
            SharedLookupCache lCache = null;
            Enumeration en = this.cacheTable.keys();
            while (en.hasMoreElements()) {
                ServiceTemplate template = (ServiceTemplate)en.nextElement();
                if (!this.templatesMatch(template, templateToMatch)) continue;
                lCache = (SharedLookupCache)this.cacheTable.get(template);
                break;
            }
            if (lCache == null) {
                LookupCache lc = this.sdm.createLookupCache(templateToMatch, (ServiceItemFilter)(this.sharedName == null ? null : new OpStringFilter(this.sharedName)), null);
                lCache = new SharedLookupCache(lc, templateToMatch, this);
                this.cacheTable.put(templateToMatch, lCache);
            }
            return lCache;
        }

        boolean templatesMatch(ServiceTemplate st1, ServiceTemplate st2) {
            return LookupCachePool.attributesMatch(st1.attributeSetTemplates, st2.attributeSetTemplates) && LookupCachePool.serviceIDsMatch(st1.serviceID, st2.serviceID) && LookupCachePool.serviceTypesMatch(st1.serviceTypes, st2.serviceTypes);
        }
    }
}

