/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.client;

import java.lang.reflect.Field;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.ServiceItemFilter;
import org.jini.rio.entry.OperationalStringEntry;

public class OpStringFilter
implements ServiceItemFilter {
    private String opStringName;

    public OpStringFilter(String opStringName) {
        if (opStringName == null) {
            throw new NullPointerException("opStringName is null");
        }
        this.opStringName = opStringName;
    }

    public boolean check(ServiceItem item) {
        if (OpStringFilter.getOperationalStringEntry(item.attributeSets) != null) {
            return OpStringFilter.matches(item.attributeSets, this.opStringName);
        }
        return true;
    }

    public static boolean matches(Entry[] attrs, String opStringName) {
        boolean matched = false;
        for (int x = 0; x < attrs.length; ++x) {
            OperationalStringEntry oe;
            if (!attrs[x].getClass().getName().equals(OperationalStringEntry.class.getName())) continue;
            if (attrs[x] instanceof OperationalStringEntry) {
                oe = (OperationalStringEntry)attrs[x];
                if (!oe.name.equals(opStringName)) continue;
                matched = true;
                break;
            }
            oe = new OperationalStringEntry();
            try {
                Field name = attrs[x].getClass().getDeclaredField("name");
                oe.name = (String)name.get(attrs[x]);
                if (!oe.name.equals(opStringName)) continue;
                matched = true;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return matched;
    }

    public static OperationalStringEntry getOperationalStringEntry(Entry[] attrs) {
        for (int x = 0; x < attrs.length; ++x) {
            if (!attrs[x].getClass().getName().equals(OperationalStringEntry.class.getName())) continue;
            if (attrs[x] instanceof OperationalStringEntry) {
                return (OperationalStringEntry)attrs[x];
            }
            OperationalStringEntry oe = new OperationalStringEntry();
            try {
                Field name = attrs[x].getClass().getDeclaredField("name");
                oe.name = (String)name.get(attrs[x]);
            }
            catch (Exception e) {
                e.printStackTrace();
                oe = null;
            }
            return oe;
        }
        return null;
    }
}

