/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.client;

import com.gigaspaces.time.SystemTime;
import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lease.Lease;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.core.MonitorableService;
import org.jini.rio.resources.client.AbstractFaultDetectionHandler;
import org.jini.rio.resources.util.TimeUtil;

public class StandardFaultDetectionHandler
extends AbstractFaultDetectionHandler {
    public static final long DEFAULT_LEASE_DURATION = 60000L;
    public static final String LEASE_DURATION_KEY = "leaseDuration";
    private long leaseDuration = 60000L;
    private ProxyPreparer leasePreparer;
    private static final String COMPONENT = "org.jini.rio.resources.client.StandardFaultDetectionHandler";
    static Logger logger = Logger.getLogger("org.jini.rio.resources.client.StandardFaultDetectionHandler");

    @Override
    public void setConfiguration(String[] configArgs) {
        if (configArgs == null) {
            throw new NullPointerException("configArgs is null");
        }
        try {
            this.configArgs = new String[configArgs.length];
            System.arraycopy(configArgs, 0, this.configArgs, 0, configArgs.length);
            this.config = ConfigurationProvider.getInstance((String[])configArgs);
            this.leaseDuration = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)LEASE_DURATION_KEY, (long)60000L, (long)0L, (long)Long.MAX_VALUE);
            this.retryCount = Config.getIntEntry((Configuration)this.config, (String)COMPONENT, (String)"retryCount", (int)3, (int)0, (int)Integer.MAX_VALUE);
            this.retryTimeout = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)"retryTimeout", (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            this.leasePreparer = (ProxyPreparer)this.config.getEntry(COMPONENT, "leasePreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            if (logger.isLoggable(Level.CONFIG)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("StandardFaultDetectionHandler Properties : ");
                buffer.append("lease duration=" + this.leaseDuration + ", ");
                buffer.append("retry count=" + this.retryCount + ", ");
                buffer.append("retry timeout=" + this.retryTimeout);
                logger.config(buffer.toString());
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.SEVERE, "Setting Configuration", e);
        }
    }

    @Override
    protected boolean canbeScheduled() {
        return false;
    }

    @Override
    protected AbstractFaultDetectionHandler.ServiceMonitor getServiceMonitor() throws Exception {
        AbstractFaultDetectionHandler.ServiceMonitor monitor = null;
        if (this.proxy instanceof MonitorableService) {
            MonitorableService service = (MonitorableService)this.proxy;
            Lease lease = null;
            lease = service.monitor(this.leaseDuration);
            lease = (Lease)this.leasePreparer.prepareProxy((Object)lease);
            this.serviceMonitor = new ServiceLeaseManager(lease);
        } else {
            logger.info("Service [" + this.proxy.getClass().getName() + "] not an instanceof " + MonitorableService.class.getName() + ", ServiceRegistrar.TRANSITION_MATCH_NOMATCH transitions will only be monitored");
        }
        return monitor;
    }

    class ServiceLeaseManager
    extends Thread
    implements AbstractFaultDetectionHandler.ServiceMonitor {
        long leaseTime;
        boolean keepAlive;
        Lease lease;

        ServiceLeaseManager(Lease lease) {
            super("ServiceLeaseManager:" + StandardFaultDetectionHandler.this.proxy.getClass().getName() + ":" + System.currentTimeMillis());
            this.keepAlive = true;
            this.lease = lease;
            this.leaseTime = lease.getExpiration() - SystemTime.timeMillis();
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void drop() {
            try {
                this.lease.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.keepAlive = false;
            this.interrupt();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Dropping monitor for service: [" + StandardFaultDetectionHandler.this.getServiceID() + "]");
            }
        }

        @Override
        public void reportFirstError() {
        }

        @Override
        public void reportLastError() {
        }

        @Override
        public boolean verify() {
            if (!this.keepAlive) {
                return false;
            }
            boolean verified = false;
            try {
                MonitorableService service = (MonitorableService)StandardFaultDetectionHandler.this.proxy;
                service.ping();
                verified = true;
            }
            catch (RemoteException e) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("RemoteException reaching service, service cannot be reached");
                }
                this.keepAlive = false;
            }
            return verified;
        }

        @Override
        public boolean shouldRetry() {
            return true;
        }

        @Override
        public void run() {
            while (!ServiceLeaseManager.interrupted()) {
                if (!this.keepAlive) {
                    return;
                }
                long leaseRenewalTime = TimeUtil.computeLeaseRenewalTime(this.leaseTime);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("ServiceLeaseManager: Lease renewal wait for [" + leaseRenewalTime + "] millis for " + StandardFaultDetectionHandler.this.proxy.getClass().getName());
                }
                try {
                    ServiceLeaseManager.sleep(leaseRenewalTime);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IllegalArgumentException iae) {
                    logger.warning("ServiceLeaseManager: sleep time is off : " + leaseRenewalTime);
                }
                if (this.lease == null) continue;
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Renew lease for : " + StandardFaultDetectionHandler.this.proxy.getClass().getName());
                    }
                    this.lease.renew(this.leaseTime);
                }
                catch (Exception e) {
                    int category = ThrowableConstants.retryable((Throwable)e);
                    if (category == 1 || category == 2) {
                        this.keepAlive = false;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Unrecoverable Exception renewingLease", e);
                        }
                    }
                    if (this.keepAlive) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Failed to renew lease to : " + StandardFaultDetectionHandler.this.proxy.getClass().getName() + ", retry [" + StandardFaultDetectionHandler.this.retryCount + "] times, waiting [" + StandardFaultDetectionHandler.this.retryTimeout + "] millis between attempts");
                        }
                        boolean connected = false;
                        for (int i = 0; i < StandardFaultDetectionHandler.this.retryCount; ++i) {
                            long t0 = 0L;
                            long t1 = 0L;
                            try {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Attempt to re-establish Lease to : " + StandardFaultDetectionHandler.this.proxy.getClass().getName() + ", attempt [" + i + "]");
                                }
                                MonitorableService service = (MonitorableService)StandardFaultDetectionHandler.this.proxy;
                                t0 = System.currentTimeMillis();
                                this.lease = service.monitor(StandardFaultDetectionHandler.this.leaseDuration);
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Re-established Lease to : " + StandardFaultDetectionHandler.this.proxy.getClass().getName());
                                }
                                connected = true;
                                break;
                            }
                            catch (Exception e1) {
                                t1 = System.currentTimeMillis();
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Invocation attempt [" + i + "] took [" + (t1 - t0) + "] millis to fail for : " + StandardFaultDetectionHandler.this.proxy.getClass().getName());
                                }
                                if (StandardFaultDetectionHandler.this.retryTimeout <= 0L) continue;
                                try {
                                    ServiceLeaseManager.sleep(StandardFaultDetectionHandler.this.retryTimeout);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                continue;
                            }
                        }
                        if (connected) continue;
                        if (logger.isLoggable(Level.FINEST)) {
                            if (StandardFaultDetectionHandler.this.proxy != null) {
                                logger.finest("Unable to recover Lease to [" + StandardFaultDetectionHandler.this.proxy.getClass().getName() + "], notify listeners and exit");
                            } else {
                                logger.finest("Unable to recover Lease to [null proxy], notify listeners and exit");
                            }
                        }
                        StandardFaultDetectionHandler.this.notifyListeners();
                        break;
                    }
                    StandardFaultDetectionHandler.this.notifyListeners();
                    break;
                }
            }
            StandardFaultDetectionHandler.this.terminate();
        }
    }
}

