/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class FileSystem {
    public static void destroy(File file, boolean proceed) throws IOException {
        if (!file.exists() || file.delete()) {
            return;
        }
        ArrayList errors = proceed ? new ArrayList() : null;
        FileSystem.destroyDir(file, errors);
        if (errors != null && errors.size() != 0) {
            StringBuffer buf = new StringBuffer("couldn't delete:");
            for (int i = 0; i < errors.size(); ++i) {
                buf.append('\n').append(errors.get(i));
            }
            throw new IOException(buf.toString());
        }
    }

    private static void destroyDir(File dir, Collection errors) throws IOException {
        if (!dir.isDirectory()) {
            FileSystem.handleError(errors, dir);
            return;
        }
        String[] names = dir.list();
        for (int i = 0; i < names.length; ++i) {
            File file = new File(dir, names[i]);
            if (file.delete()) continue;
            FileSystem.destroyDir(file, errors);
        }
        if (!dir.delete()) {
            FileSystem.handleError(errors, dir);
        }
    }

    private static void handleError(Collection errors, File path) throws IOException {
        if (errors == null) {
            throw new IOException("couldn't delete " + path);
        }
        errors.add(path);
    }

    public static void ensureDir(String path) throws IllegalArgumentException {
        File dir = new File(path);
        if (dir.isDirectory()) {
            return;
        }
        if (dir.exists()) {
            throw new IllegalArgumentException(path + " exists, but not a dir");
        }
        if (!dir.mkdirs()) {
            throw new IllegalArgumentException(path + ": cannot create");
        }
    }
}

