/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.persistence;

import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import com.sun.jini.thread.ReadersWriter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jini.rio.resources.persistence.CorruptedStoreException;
import org.jini.rio.resources.persistence.FileSystem;
import org.jini.rio.resources.persistence.SnapshotHandler;
import org.jini.rio.resources.persistence.StoreException;
import org.jini.rio.resources.persistence.SubStore;

public class PersistentStore {
    private ReliableLog log;
    private final ReadersWriter mutatorLock = new ReadersWriter();
    private static final ThreadLocal lockState = new ThreadLocal();
    private static final Long zero = new Long(0L);
    private final File storeLocation;
    private final SnapshotHandler snapshotHandler;
    private int updateCount;
    private final List subStores = new LinkedList();

    public PersistentStore(String logDir, LogHandler logHandler, SnapshotHandler snapshotHandler) throws StoreException {
        this.snapshotHandler = snapshotHandler;
        this.storeLocation = new File(logDir);
        try {
            this.log = new ReliableLog(this.storeLocation.getCanonicalPath(), logHandler);
        }
        catch (IOException e) {
            throw new CorruptedStoreException("Failure creating reliable log", e);
        }
        try {
            this.log.recover();
        }
        catch (IOException e) {
            throw new CorruptedStoreException("Failure recovering reliable log", e);
        }
    }

    public void destroy() throws IOException {
        for (SubStore subStore : this.subStores) {
            subStore.prepareDestroy();
        }
        if (Boolean.getBoolean("com.gs.persistency.delete_current_on_destroy")) {
            this.log.deletePersistentStore();
            FileSystem.destroy(this.storeLocation, true);
        }
    }

    public String getStoreLocation() {
        return this.storeLocation.getAbsolutePath();
    }

    public void addSubStore(SubStore subStore) throws StoreException {
        try {
            String subDir = subStore.subDirectory();
            if (subDir == null) {
                subStore.setDirectory(this.storeLocation);
            } else {
                subStore.setDirectory(new File(this.storeLocation, subDir));
            }
            this.subStores.add(subStore);
        }
        catch (IOException e) {
            throw new StoreException("Failure adding substore " + subStore, e);
        }
    }

    public void acquireMutatorLock() {
        long longVal;
        Long lockStateVal = (Long)lockState.get();
        if (lockStateVal == null) {
            lockStateVal = zero;
        }
        if ((longVal = lockStateVal.longValue()) == 0L) {
            this.mutatorLock.readLock();
        }
        lockState.set(new Long(longVal + 1L));
    }

    public void releaseMutatorLock() {
        long longVal;
        Long lockStateVal = (Long)lockState.get();
        if (lockStateVal == null) {
            lockStateVal = zero;
        }
        if ((longVal = lockStateVal.longValue()) == 0L) {
            return;
        }
        if (longVal == 1L) {
            this.mutatorLock.readUnlock();
            lockStateVal = zero;
        } else {
            lockStateVal = new Long(longVal - 1L);
        }
        lockState.set(lockStateVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object o) throws IOException {
        Long lockStateVal = (Long)lockState.get();
        if (lockStateVal == null || lockStateVal == 0L) {
            throw new IllegalStateException("PersistentStrore.update:Must acquire mutator lock before calling update()");
        }
        PersistentStore persistentStore = this;
        synchronized (persistentStore) {
            this.log.update(o, true);
            ++this.updateCount;
            this.snapshotHandler.updatePerformed(this.updateCount);
        }
    }

    public void snapshot() throws IOException {
        try {
            this.mutatorLock.writeLock();
            this.updateCount = 0;
            this.log.snapshot();
        }
        finally {
            this.mutatorLock.writeUnlock();
        }
    }

    public void close() throws IOException {
        try {
            this.mutatorLock.writeLock();
            this.updateCount = 0;
            this.log.close();
        }
        finally {
            this.mutatorLock.writeUnlock();
        }
    }
}

