/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.servicecore;

import com.gigaspaces.grid.security.gsa.SecuredServiceAdminProxy;
import com.gigaspaces.grid.security.interceptor.PrivilegedProxySecurityInterceptor;
import com.gigaspaces.grid.security.interceptor.ProxySecurityInterceptor;
import com.gigaspaces.grid.zone.GridZoneProvider;
import com.gigaspaces.internal.dump.InternalDumpException;
import com.gigaspaces.internal.dump.InternalDumpProvider;
import com.gigaspaces.internal.dump.InternalDumpResult;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.internal.log.InternalLogProvider;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSInfoProvider;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoProvider;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.RemoteSecuredService;
import com.gigaspaces.security.service.SecurityContext;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;
import net.jini.admin.Administrable;
import net.jini.config.ConfigurationException;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.lookup.SameProxyVersionProvider;
import org.jini.rio.core.MonitorableService;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventProducer;
import org.jini.rio.resources.servicecore.Service;
import org.jini.rio.resources.servicecore.ServiceAdmin;
import org.jini.rio.watch.WatchDataSource;
import org.jini.rio.watch.Watchable;

public abstract class AbstractProxy
implements ReferentUuid,
SameProxyVersionProvider,
Service,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final Remote server;
    protected final Uuid uuid;
    private transient ProxySecurityInterceptor securityInterceptor = ProxySecurityInterceptor.UNTRUSTED;
    private transient NIODetails nioDetails;
    private transient OSDetails osDetails;
    private transient JVMDetails jvmDetails;
    private transient String[] zones;

    protected AbstractProxy(Remote server, Uuid uuid) {
        if (server == null) {
            throw new NullPointerException("server cannot be null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid cannot be null");
        }
        this.server = server;
        this.uuid = uuid;
        if (this.isSecuredProxy()) {
            this.securityInterceptor = ProxySecurityInterceptor.TRUSTED;
        }
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object o) {
        return ReferentUuids.compare((Object)this, (Object)o);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.server + "]";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("AbstractProxy.readObject failure - server field is null");
        }
        if (this.uuid == null) {
            throw new InvalidObjectException("AbstractProxy.uuid failure - uuid field is null");
        }
        if (this.isSecuredProxy()) {
            this.securityInterceptor = ProxySecurityInterceptor.UNTRUSTED;
        }
    }

    public Object getVersion() {
        return this.uuid;
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("No data found when attempting to deserialize AbstractProxy instance");
    }

    public void ping() throws RemoteException {
        ((MonitorableService)this.server).ping();
    }

    public Lease monitor(long duration) throws LeaseDeniedException, RemoteException {
        return ((MonitorableService)this.server).monitor(duration);
    }

    public void startHeartbeat(String[] configArgs) throws ConfigurationException, RemoteException {
        ((MonitorableService)this.server).startHeartbeat(configArgs);
    }

    public EventRegistration register(EventDescriptor descriptor, RemoteEventListener listener, MarshalledObject handback, long duration) throws LeaseDeniedException, UnknownEventException, RemoteException {
        return ((EventProducer)this.server).register(descriptor, listener, handback, duration);
    }

    public WatchDataSource[] fetch() throws RemoteException {
        return ((Watchable)this.server).fetch();
    }

    public WatchDataSource[] fetch(String id) throws RemoteException {
        return ((Watchable)this.server).fetch(id);
    }

    public Object getAdmin() throws RemoteException {
        Object admin = ((Administrable)this.server).getAdmin();
        return this.isSecuredProxy() ? this.secureAdmin((ServiceAdmin)admin, this.securityInterceptor) : admin;
    }

    public Uuid getReferentUuid() {
        return this.uuid;
    }

    public NIODetails getNIODetails() throws RemoteException {
        if (this.nioDetails != null) {
            return this.nioDetails;
        }
        this.nioDetails = ((NIOInfoProvider)this.server).getNIODetails();
        return this.nioDetails;
    }

    public NIOStatistics getNIOStatistics() throws RemoteException {
        return ((NIOInfoProvider)this.server).getNIOStatistics();
    }

    public void enableLRMIMonitoring() throws RemoteException {
        ((NIOInfoProvider)this.server).enableLRMIMonitoring();
    }

    public void disableLRMIMonitoring() throws RemoteException {
        ((NIOInfoProvider)this.server).disableLRMIMonitoring();
    }

    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return ((NIOInfoProvider)this.server).fetchLRMIMonitoringDetails();
    }

    public long getCurrentTimestamp() throws RemoteException {
        return ((OSInfoProvider)this.server).getCurrentTimestamp();
    }

    public OSDetails getOSDetails() throws RemoteException {
        if (this.osDetails != null) {
            return this.osDetails;
        }
        this.osDetails = ((OSInfoProvider)this.server).getOSDetails();
        return this.osDetails;
    }

    public OSStatistics getOSStatistics() throws RemoteException {
        return ((OSInfoProvider)this.server).getOSStatistics();
    }

    public JVMDetails getJVMDetails() throws RemoteException {
        if (this.jvmDetails != null) {
            return this.jvmDetails;
        }
        this.jvmDetails = ((JVMInfoProvider)this.server).getJVMDetails();
        return this.jvmDetails;
    }

    public JVMStatistics getJVMStatistics() throws RemoteException {
        return ((JVMInfoProvider)this.server).getJVMStatistics();
    }

    public void runGc() throws RemoteException {
        ((JVMInfoProvider)this.server).runGc();
    }

    public String[] getZones() throws RemoteException {
        if (this.zones != null) {
            return this.zones;
        }
        this.zones = ((GridZoneProvider)this.server).getZones();
        return this.zones;
    }

    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws RemoteException, IOException {
        return InternalLogHelper.clientSideProcess((LogEntryMatcher)matcher, (LogEntries)((InternalLogProvider)this.server).logEntriesDirect(matcher));
    }

    public void reloadMetricConfiguration() throws RemoteException {
        ((InternalDumpProvider)this.server).reloadMetricConfiguration();
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context) throws RemoteException, InternalDumpException {
        this.interceptGenerateDump(null);
        return ((InternalDumpProvider)this.server).generateDump(cause, context);
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context, String ... contributors) throws RemoteException, InternalDumpException {
        this.interceptGenerateDump(contributors);
        return ((InternalDumpProvider)this.server).generateDump(cause, context, contributors);
    }

    public byte[] dumpBytes(String file, long from, int length) throws RemoteException, IOException {
        this.intercept((Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM);
        return ((InternalDumpProvider)this.server).dumpBytes(file, from, length);
    }

    protected SecurityContext login(RemoteSecuredService server, CredentialsProvider credentialsProvider) throws RemoteException {
        SecurityContext securityContext = server.login(new SecurityContext(credentialsProvider));
        if (this.isSecuredProxy()) {
            this.securityInterceptor = new PrivilegedProxySecurityInterceptor(securityContext.getAuthentication());
        }
        return securityContext;
    }

    protected void intercept(Privilege privilege) {
        if (this.isSecuredProxy()) {
            this.securityInterceptor.intercept(privilege);
        }
    }

    private void interceptGenerateDump(String[] processors) throws RemoteException, InternalDumpException {
        if (!this.isSecuredProxy()) {
            return;
        }
        boolean interceptMonitorPu = false;
        boolean interceptMonitorJvm = false;
        if (processors == null) {
            interceptMonitorJvm = true;
            interceptMonitorPu = true;
        } else {
            for (String proc : processors) {
                if ("processingUnits".equals(proc)) {
                    interceptMonitorPu = true;
                    continue;
                }
                interceptMonitorJvm = true;
            }
        }
        if (interceptMonitorJvm) {
            this.intercept((Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM);
        }
        if (interceptMonitorPu) {
            this.intercept((Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU);
        }
    }

    protected boolean isSecuredProxy() {
        return false;
    }

    protected Object secureAdmin(ServiceAdmin admin, ProxySecurityInterceptor securityInterceptor) {
        return new SecuredServiceAdminProxy<ServiceAdmin>(admin, securityInterceptor);
    }
}

