/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.servicecore;

import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import org.jini.rio.resources.servicecore.ServiceAdmin;
import org.jini.rio.resources.servicecore.ServiceAdminProxy;

public class ConstrainableServiceAdminProxy
extends ServiceAdminProxy
implements RemoteMethodControl {
    private static final long serialVersionUID = 2L;
    private final MethodConstraints constraints;

    ConstrainableServiceAdminProxy(ServiceAdmin serviceAdmin, ServiceAdmin localAdmin, Uuid id, MethodConstraints constraints) {
        super(ConstrainableServiceAdminProxy.constrainServer(serviceAdmin, constraints), ConstrainableServiceAdminProxy.constrainServer(localAdmin, constraints), id);
        this.constraints = constraints;
    }

    private static ServiceAdmin constrainServer(ServiceAdmin serviceAdmin, MethodConstraints constraints) {
        if (serviceAdmin == null) {
            return null;
        }
        Method[] methods = ServiceAdmin.class.getMethods();
        Method[] methodMapping = new Method[methods.length * 2];
        for (int i = 0; i < methodMapping.length; ++i) {
            methodMapping[i] = methods[i / 2];
        }
        return (ServiceAdmin)((RemoteMethodControl)serviceAdmin).setConstraints(ConstrainableProxyUtil.translateConstraints((MethodConstraints)constraints, (Method[])methodMapping));
    }

    public RemoteMethodControl setConstraints(MethodConstraints constraints) {
        return new ConstrainableServiceAdminProxy(this.serviceAdmin, this.localAdmin, this.uuid, constraints);
    }

    public MethodConstraints getConstraints() {
        return this.constraints;
    }

    private ProxyTrustIterator getProxyTrustIterator() {
        return new SingletonProxyTrustIterator((Object)this.serviceAdmin);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (!(this.serviceAdmin instanceof RemoteMethodControl)) {
            throw new InvalidObjectException("ConstrainableServiceAdminProxy.readObject failure - server does not implement constrainable functionality ");
        }
    }
}

