/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.servicecore;

import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.jsb.ServiceBeanContext;

public class Destroyer
extends Thread {
    private ActivationID activationID;
    private ServiceBeanContext context;
    private static final long DEFAULT_KILL_WAIT = 2000L;
    private long killWait;
    private boolean force = false;
    private Logger logger = Logger.getLogger("org.jini.rio.resources.servicecore");

    public Destroyer(ActivationID activationID, ServiceBeanContext context) {
        this(activationID, context, 2000L, false);
    }

    public Destroyer(ActivationID activationID, ServiceBeanContext context, boolean force) {
        this(activationID, context, 2000L, force);
    }

    public Destroyer(ActivationID activationID, ServiceBeanContext context, long killWait) {
        this(activationID, context, killWait, false);
    }

    public Destroyer(ActivationID activationID, ServiceBeanContext context, long killWait, boolean force) {
        super("Destroyer");
        this.activationID = activationID;
        this.context = context;
        this.force = force;
        this.killWait = killWait;
        this.start();
    }

    @Override
    public void run() {
        if (this.activationID != null) {
            ActivationGroupID gid = ActivationGroup.currentGroupID();
            try {
                Activatable.inactive((ActivationID)this.activationID);
                Activatable.unregister((ActivationID)this.activationID);
            }
            catch (RemoteException e) {
                this.logger.log(Level.SEVERE, "Communicating to Activation System", e);
            }
            catch (ActivationException e) {
                this.logger.log(Level.SEVERE, "Communicating to Activation System", e);
            }
            if (!this.force && this.context == null) {
                this.logger.severe("Cannot determine Activatable object's context. Unable to unregister the ActivationGroup or terminate the JVM");
                return;
            }
            if (this.force) {
                try {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Unregister ActivationGroup");
                    }
                    if (gid != null) {
                        ActivationGroup.getSystem().unregisterGroup(gid);
                    } else if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Unable to unregister ActivationGroup: groupID is null");
                    }
                }
                catch (RemoteException e) {
                    this.logger.warning("RemoteException unregistering Activation group");
                }
                catch (ActivationException e) {
                    this.logger.warning("ActivationException unregistering Activation group");
                }
                this.killVM(this.killWait);
            }
        } else {
            this.killVM(this.killWait);
        }
    }

    private void killVM(long wait) {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Shutting down the JVM in " + wait / 1000L + " seconds ...");
            }
            Thread.sleep(wait);
        }
        catch (InterruptedException e) {
            this.logger.warning("Interrupted while waiting");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("JVM Shutting down");
        }
        System.exit(0);
    }
}

