/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.servicecore;

import com.gigaspaces.time.SystemTime;
import com.sun.jini.config.Config;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.landlord.SystemTimeFixedLeasePeriodPolicy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMapException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.resources.servicecore.ResourceLessor;

public class LandlordLessor
extends ResourceLessor
implements Landlord {
    public static final long DEFAULT_LEASE_TIME = 300000L;
    public static final long DEFAULT_MAX_LEASE_TIME = 86400000L;
    private volatile Landlord landlord;
    Exporter exporter;
    LeaseFactory leaseFactory;
    LeasePeriodPolicy leasePolicy;
    static final String COMPONENT = "org.jini.rio.resources.servicecore";
    static Logger logger = Logger.getLogger("org.jini.rio.resources.servicecore");

    public LandlordLessor(Configuration config) throws RemoteException {
        this(config, null);
    }

    public LandlordLessor(Configuration config, LeasePeriodPolicy leasePolicy) throws RemoteException {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        SystemTimeFixedLeasePeriodPolicy defaultLeasePeriodPolicy = new SystemTimeFixedLeasePeriodPolicy(86400000L, 300000L);
        if (leasePolicy == null) {
            try {
                this.leasePolicy = (LeasePeriodPolicy)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"landlordLeasePeriodPolicy", LeasePeriodPolicy.class, (Object)defaultLeasePeriodPolicy);
            }
            catch (ConfigurationException e) {
                logger.log(Level.WARNING, "Getting LeasePeriodPolicy in LandlordLessor", e);
            }
        }
        if (this.leasePolicy == null) {
            this.leasePolicy = defaultLeasePeriodPolicy;
        }
        try {
            this.exporter = ExporterConfig.getExporter(config, COMPONENT, "landlordExporter");
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Getting Exporter in LandlordLessor", e);
        }
        this.landlord = (Landlord)this.exporter.export((Remote)((Object)this));
        this.leaseFactory = new LeaseFactory(this.landlord, UuidFactory.generate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(boolean force) {
        super.stop();
        boolean unexported = false;
        try {
            unexported = this.exporter.unexport(force);
        }
        catch (Exception exception) {
        }
        finally {
            this.landlord = null;
        }
        return unexported;
    }

    @Override
    public Lease newLease(LeasedResource resource, long duration) throws LeaseDeniedException {
        LeasePeriodPolicy.Result leasePeriod = this.leasePolicy.grant(resource, duration);
        LandlordLease lease = this.leaseFactory.newLease(resource.getCookie(), leasePeriod.expiration);
        resource.setExpiration(leasePeriod.expiration);
        this.resources.put(resource.getCookie(), resource);
        this.notifyLeaseRegistration(resource);
        return lease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renew(Uuid cookie, long extension) throws LeaseDeniedException, UnknownLeaseException {
        LeasedResource resource = (LeasedResource)this.resources.get(cookie);
        long granted = 0L;
        if (resource == null) {
            throw new UnknownLeaseException("No lease for cookie: " + cookie);
        }
        LeasedResource leasedResource = resource;
        synchronized (leasedResource) {
            long now = SystemTime.timeMillis();
            if (resource.getExpiration() <= now) {
                UnknownLeaseException e = new UnknownLeaseException("Lease has already expired");
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Lease has already expired by [" + (now - resource.getExpiration()) + "] millis, [" + (now - resource.getExpiration()) / 1000L + "] seconds");
                    logger.throwing(this.getClass().getName(), "renew", (Throwable)e);
                }
                if (this.remove(cookie)) {
                    this.notifyLeaseExpiration(resource);
                }
                throw e;
            }
            LeasePeriodPolicy.Result leasePeriod = this.leasePolicy.renew(resource, extension);
            resource.setExpiration(leasePeriod.expiration);
            granted = leasePeriod.duration;
            this.resources.put(resource.getCookie(), resource);
            this.notifyLeaseRenewal(resource);
        }
        return granted;
    }

    public Landlord.RenewResults renewAll(Uuid[] cookie, long[] extension) {
        int size = cookie.length;
        long[] granted = new long[size];
        Exception[] denied = null;
        for (int i = 0; i < size; ++i) {
            try {
                granted[i] = this.renew(cookie[i], extension[i]);
                denied[i] = null;
                continue;
            }
            catch (Exception e) {
                if (denied == null) {
                    denied = new Exception[size];
                }
                denied[i] = e;
            }
        }
        return new Landlord.RenewResults(granted, denied);
    }

    public void cancel(Uuid cookie) throws UnknownLeaseException {
        if (!this.remove(cookie)) {
            throw new UnknownLeaseException("No lease for cookie: " + cookie);
        }
    }

    public Map cancelAll(Uuid[] cookies) {
        int size = cookies.length;
        HashMap<Uuid, Exception> exceptionMap = null;
        LeaseMapException lme = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.cancel(cookies[i]);
                continue;
            }
            catch (Exception e) {
                if (lme == null) {
                    exceptionMap = new HashMap<Uuid, Exception>();
                    lme = new LeaseMapException(e.getMessage(), exceptionMap);
                }
                exceptionMap.put(cookies[i], e);
            }
        }
        return exceptionMap;
    }

    public LeasedResource[] getLeasedResources() {
        LeasedResource[] leasedResource = null;
        Collection c = this.resources.values();
        leasedResource = c.toArray(new LeasedResource[c.size()]);
        return leasedResource;
    }
}

