/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.servicecore;

import com.gigaspaces.time.SystemTime;
import com.sun.jini.landlord.LeasedResource;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import org.jini.rio.resources.servicecore.LeaseListener;
import org.jini.rio.resources.servicecore.ServiceResource;

public abstract class ResourceLessor {
    protected Map resources = null;
    private volatile LeaseReaper reaper = null;
    private final List listeners = new CopyOnWriteArrayList();
    static final String COMPONENT_NAME = "org.jini.rio.resources.servicecore";
    static final Logger logger = Logger.getLogger("org.jini.rio.resources.servicecore");

    public ResourceLessor() {
        this.resources = new ConcurrentHashMap();
        this.reaper = new LeaseReaper(this);
        this.reaper.setDaemon(true);
        this.reaper.start();
    }

    public boolean ensure(LeasedResource resource) {
        return resource.getExpiration() > this.currentTime();
    }

    public abstract Lease newLease(LeasedResource var1, long var2) throws LeaseDeniedException;

    public boolean remove(ServiceResource resource) {
        return this.remove(resource.getCookie());
    }

    public void removeAll() {
        ServiceResource[] resources = this.getServiceResources();
        for (int i = 0; i < resources.length; ++i) {
            this.remove(resources[i]);
        }
    }

    boolean remove(Object cookie) {
        LeasedResource resource = null;
        boolean removed = false;
        resource = (LeasedResource)this.resources.remove(cookie);
        if (resource != null) {
            this.notifyLeaseRemoval(resource);
            removed = true;
        }
        return removed;
    }

    public void addLeaseListener(LeaseListener listener) {
        this.listeners.add(listener);
    }

    public void removeLeaseListener(LeaseListener listener) {
        this.listeners.remove(listener);
    }

    public int total() {
        return this.resources.size();
    }

    protected ServiceResource[] getServiceResources() {
        ServiceResource[] svcResources = null;
        Collection c = this.resources.values();
        svcResources = c.toArray(new ServiceResource[c.size()]);
        return svcResources;
    }

    protected void notifyLeaseRegistration(LeasedResource resource) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((LeaseListener)iter.next()).register(resource);
        }
    }

    protected void notifyLeaseRenewal(LeasedResource resource) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((LeaseListener)iter.next()).renewed(resource);
        }
    }

    protected void notifyLeaseExpiration(LeasedResource resource) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((LeaseListener)iter.next()).expired(resource);
        }
    }

    protected Map resources() {
        return this.resources;
    }

    protected void notifyLeaseRemoval(LeasedResource resource) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((LeaseListener)iter.next()).removed(resource);
        }
    }

    protected void stop() {
        if (this.reaper != null) {
            this.reaper.stopReaper();
            this.reaper.interrupt();
        }
        this.reaper = null;
        this.removeAll();
    }

    protected long currentTime() {
        return SystemTime.timeMillis();
    }

    private static class LeaseReaper
    extends Thread {
        private volatile boolean stopped = false;
        private volatile ResourceLessor lessor;

        public LeaseReaper(ResourceLessor lessor) {
            super("SG LeaseReaper");
            this.lessor = lessor;
        }

        public void stopReaper() {
            this.stopped = true;
        }

        @Override
        public void run() {
            while (!this.stopped && !this.isInterrupted()) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                for (Object value : this.lessor.resources().values()) {
                    ServiceResource r = (ServiceResource)value;
                    if (this.lessor.ensure(r)) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Lease expired for resource {0}, cookie {1}", new Object[]{r.getResource(), r.getCookie()});
                    }
                    if (!this.lessor.remove(r.getCookie())) continue;
                    this.lessor.notifyLeaseExpiration(r);
                }
            }
            this.lessor = null;
        }
    }
}

