/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.servicecore;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.export.Exporter;
import net.jini.id.UuidFactory;
import net.jini.lookup.JoinManager;
import org.jini.rio.core.JSBControlException;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.cybernode.ServiceBeanLoader;
import org.jini.rio.jsb.JSBContext;
import org.jini.rio.jsb.ServiceBeanAdapter;
import org.jini.rio.resources.persistence.SnapshotHandler;
import org.jini.rio.resources.servicecore.ServiceAdmin;
import org.jini.rio.resources.servicecore.ServiceAdminProxy;

public class ServiceAdminImpl
implements ServiceAdmin {
    private ServiceBeanAdapter service;
    private ServiceBeanContext context;
    protected Exporter exporter;
    protected ServiceAdminProxy adminProxy;
    SnapshotHandler snapshotHandler;
    long started;
    static Logger logger = Logger.getLogger("org.jini.rio.resources.servicecore");

    public ServiceAdminImpl(ServiceBeanAdapter service, Exporter exporter) {
        this(service, exporter, null);
    }

    public ServiceAdminImpl(ServiceBeanAdapter service, Exporter exporter, SnapshotHandler snapshotHandler) {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        this.service = service;
        this.exporter = exporter;
        this.snapshotHandler = snapshotHandler;
        this.started = service.getStartTime();
        this.setServiceBeanContext(service.getServiceBeanContext());
    }

    @Override
    public ServiceRegistrar[] getJoinSet() {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            return mgr.getJoinSet();
        }
        logger.warning("JoinManager is null");
        return new ServiceRegistrar[0];
    }

    public ServiceAdmin getServiceAdmin() throws RemoteException {
        if (this.adminProxy == null) {
            ServiceAdmin serviceAdminRemoteRef = (ServiceAdmin)this.exporter.export((Remote)this);
            this.adminProxy = ServiceAdminProxy.getInstance(serviceAdminRemoteRef, this, UuidFactory.generate());
        }
        return this.adminProxy;
    }

    public void unexport(boolean force) {
        if (this.exporter != null) {
            try {
                this.exporter.unexport(true);
            }
            catch (IllegalStateException e) {
                logger.warning("ServiceAdminImpl not exported");
            }
        }
    }

    public void destroy() {
        this.service.destroy();
    }

    @Override
    public void undeployEvent() throws RemoteException {
        this.service.undeployEvent();
    }

    @Override
    public ServiceElement getServiceElement() {
        return this.service.getServiceBeanContext().getServiceElement();
    }

    @Override
    public void setServiceElement(ServiceElement sElem) {
        try {
            ServiceBeanContext sbc = this.service.getServiceBeanContext();
            if (sbc instanceof JSBContext) {
                ((JSBContext)sbc).setServiceElement(sElem);
            } else {
                logger.log(Level.WARNING, "ServiceBeanContext {0} not an instance of JSBContext. Unable to set ServiceElement", new Object[]{sbc.toString()});
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Setting ServiceElement", t);
        }
    }

    @Override
    public long getUpTime() throws RemoteException {
        return System.currentTimeMillis() - this.started;
    }

    @Override
    public Object start() throws JSBControlException {
        Object proxy = null;
        try {
            proxy = this.service.start(this.context);
        }
        catch (Throwable t) {
            throw new JSBControlException("start failed", t);
        }
        return proxy;
    }

    @Override
    public void stop(boolean force) throws JSBControlException {
        try {
            this.service.stop(force);
        }
        catch (Throwable t) {
            throw new JSBControlException("stop failed", t);
        }
    }

    @Override
    public void advertise() throws JSBControlException {
        try {
            if (this.context != null) {
                Entry[] configuredAttrs = ServiceBeanLoader.getConfiguredAttributes(this.context);
                if (configuredAttrs.length > 0) {
                    this.service.addAttributes(configuredAttrs);
                }
            } else {
                logger.warning("ServiceBeanContext is null");
            }
            this.service.advertise();
        }
        catch (Throwable t) {
            throw new JSBControlException("advertise failed", t);
        }
    }

    @Override
    public void unadvertise() throws JSBControlException {
        try {
            this.service.unadvertise();
        }
        catch (Throwable t) {
            throw new JSBControlException("unadvertise failed", t);
        }
    }

    public void setServiceBeanContext(ServiceBeanContext context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        this.context = context;
    }

    public Entry[] getLookupAttributes() {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            return mgr.getAttributes();
        }
        logger.warning("JoinManager is null");
        return new Entry[0];
    }

    public void addLookupAttributes(Entry[] attrs) {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            if (attrs != null && attrs.length != 0) {
                mgr.addAttributes(attrs, true);
            }
            if (this.snapshotHandler != null) {
                try {
                    this.snapshotHandler.takeSnapshot();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Persisting Added Lookup Attributes", ioe);
                }
            }
        } else {
            logger.warning("JoinManager is null");
        }
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            mgr.modifyAttributes(attrSetTemplates, attrSets, true);
            if (this.snapshotHandler != null) {
                try {
                    this.snapshotHandler.takeSnapshot();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Persisting Modified Lookup Attributes", ioe);
                }
            }
        } else {
            logger.warning("JoinManager is null");
        }
    }

    public String[] getLookupGroups() {
        DiscoveryManagement dm = null;
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            dm = mgr.getDiscoveryManager();
        } else {
            try {
                dm = this.service.getServiceBeanContext().getDiscoveryManagement();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Getting DiscoveryManagement ", e);
                return new String[0];
            }
        }
        DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)dm;
        return dgm.getGroups();
    }

    public void addLookupGroups(String[] groups) {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            try {
                DiscoveryManagement dm = mgr.getDiscoveryManager();
                DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)dm;
                dgm.addGroups(groups);
                if (this.snapshotHandler != null) {
                    try {
                        this.snapshotHandler.takeSnapshot();
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "Persisting Added Lookup groups", ioe);
                    }
                }
                this.setGroups(dgm.getGroups());
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Adding Lookup Groups", ioe);
            }
        } else {
            logger.warning("JoinManager is null");
        }
    }

    public void removeLookupGroups(String[] groups) {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            try {
                DiscoveryManagement dm = mgr.getDiscoveryManager();
                DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)dm;
                dgm.removeGroups(groups);
                if (this.snapshotHandler != null) {
                    try {
                        this.snapshotHandler.takeSnapshot();
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "Persisting removed Lookup groups", ioe);
                    }
                }
                this.setGroups(dgm.getGroups());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Removing Lookup groups", e);
            }
        }
    }

    public void setLookupGroups(String[] groups) {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            try {
                DiscoveryManagement dm = mgr.getDiscoveryManager();
                DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)dm;
                dgm.setGroups(groups);
                if (this.snapshotHandler != null) {
                    try {
                        this.snapshotHandler.takeSnapshot();
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "Persisting Lookup groups", ioe);
                    }
                }
                this.setGroups(dgm.getGroups());
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Setting Lookup groups", ioe);
            }
        }
    }

    public LookupLocator[] getLookupLocators() {
        DiscoveryManagement dm = null;
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            dm = mgr.getDiscoveryManager();
        } else {
            try {
                dm = this.service.getServiceBeanContext().getDiscoveryManagement();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Getting DiscoveryManagement", e);
                return new LookupLocator[0];
            }
        }
        DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)dm;
        return dlm.getLocators();
    }

    public void addLookupLocators(LookupLocator[] locators) {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            DiscoveryManagement dm = mgr.getDiscoveryManager();
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)dm;
            dlm.addLocators(locators);
            if (this.snapshotHandler != null) {
                try {
                    this.snapshotHandler.takeSnapshot();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Persisting Added LookupLocators", ioe);
                }
            }
            this.setLocators(dlm.getLocators());
        } else {
            logger.warning("JoinManager is null");
        }
    }

    public void removeLookupLocators(LookupLocator[] locators) {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            DiscoveryManagement dm = mgr.getDiscoveryManager();
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)dm;
            dlm.removeLocators(locators);
            if (this.snapshotHandler != null) {
                try {
                    this.snapshotHandler.takeSnapshot();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Persisting removed LookupLocators", ioe);
                }
            }
            this.setLocators(dlm.getLocators());
        } else {
            logger.warning("JoinManager is null");
        }
    }

    public void setLookupLocators(LookupLocator[] locators) {
        JoinManager mgr = this.service.getJoinManager();
        if (mgr != null) {
            DiscoveryManagement dm = mgr.getDiscoveryManager();
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)dm;
            dlm.setLocators(locators);
            if (this.snapshotHandler != null) {
                try {
                    this.snapshotHandler.takeSnapshot();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Persisting LookupLocators", ioe);
                }
            }
            this.setLocators(dlm.getLocators());
        } else {
            logger.warning("JoinManager is null");
        }
    }

    private void setGroups(String[] groups) {
        ServiceBeanConfig sbConfig = this.service.getServiceBeanContext().getServiceBeanConfig();
        sbConfig.setGroups(groups);
        try {
            this.service.getServiceBeanContext().getServiceBeanManager().update(sbConfig);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Updating ServiceBeanConfig to OperationalStringManager", e);
        }
    }

    private void setLocators(LookupLocator[] locators) {
        ServiceBeanConfig sbConfig = this.service.getServiceBeanContext().getServiceBeanConfig();
        sbConfig.setLocators(locators);
        try {
            this.service.getServiceBeanContext().getServiceBeanManager().update(sbConfig);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Updating ServiceBeanConfig to OperationalStringManager", e);
        }
    }
}

