/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.servicecore;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import org.jini.rio.core.JSBControlException;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.resources.servicecore.ConstrainableServiceAdminProxy;
import org.jini.rio.resources.servicecore.ServiceAdmin;

public class ServiceAdminProxy
implements ServiceAdmin,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final ServiceAdmin serviceAdmin;
    protected final transient ServiceAdmin localAdmin;
    protected final Uuid uuid;

    static ServiceAdminProxy getInstance(ServiceAdmin serviceAdmin, ServiceAdmin localAdmin, Uuid id) {
        if (serviceAdmin instanceof RemoteMethodControl) {
            return new ConstrainableServiceAdminProxy(serviceAdmin, localAdmin, id, null);
        }
        return new ServiceAdminProxy(serviceAdmin, localAdmin, id);
    }

    protected ServiceAdminProxy(ServiceAdmin serviceAdmin, ServiceAdmin local, Uuid uuid) {
        if (serviceAdmin == null) {
            throw new NullPointerException("serviceAdmin cannot be null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid cannot be null");
        }
        this.serviceAdmin = serviceAdmin;
        this.localAdmin = local;
        this.uuid = uuid;
    }

    @Override
    public ServiceRegistrar[] getJoinSet() throws RemoteException {
        return this.getProxy().getJoinSet();
    }

    @Override
    public ServiceElement getServiceElement() throws RemoteException {
        return this.getProxy().getServiceElement();
    }

    @Override
    public void setServiceElement(ServiceElement sElem) throws RemoteException {
        this.getProxy().setServiceElement(sElem);
    }

    @Override
    public long getUpTime() throws RemoteException {
        return this.getProxy().getUpTime();
    }

    @Override
    public Object start() throws JSBControlException, RemoteException {
        return this.getProxy().start();
    }

    @Override
    public void stop(boolean force) throws JSBControlException, RemoteException {
        this.getProxy().stop(force);
    }

    @Override
    public void advertise() throws JSBControlException, RemoteException {
        this.getProxy().advertise();
    }

    @Override
    public void unadvertise() throws JSBControlException, RemoteException {
        this.getProxy().unadvertise();
    }

    public Entry[] getLookupAttributes() throws RemoteException {
        return this.getProxy().getLookupAttributes();
    }

    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        this.getProxy().addLookupAttributes(attrSets);
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        this.getProxy().modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    public String[] getLookupGroups() throws RemoteException {
        return this.getProxy().getLookupGroups();
    }

    public void addLookupGroups(String[] groups) throws RemoteException {
        this.getProxy().addLookupGroups(groups);
    }

    public void removeLookupGroups(String[] groups) throws RemoteException {
        this.getProxy().removeLookupGroups(groups);
    }

    public void setLookupGroups(String[] groups) throws RemoteException {
        this.getProxy().setLookupGroups(groups);
    }

    public LookupLocator[] getLookupLocators() throws RemoteException {
        return this.getProxy().getLookupLocators();
    }

    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.getProxy().addLookupLocators(locators);
    }

    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.getProxy().removeLookupLocators(locators);
    }

    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.getProxy().setLookupLocators(locators);
    }

    public void destroy() throws RemoteException {
        this.getProxy().destroy();
    }

    @Override
    public void undeployEvent() throws RemoteException {
        this.getProxy().undeployEvent();
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object o) {
        return ReferentUuids.compare((Object)this, (Object)o);
    }

    public Uuid getReferentUuid() {
        return this.uuid;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.serviceAdmin == null) {
            throw new InvalidObjectException("ServiceAdminProxy.readObject failure - serviceAdmin field is null");
        }
        if (this.uuid == null) {
            throw new InvalidObjectException("ServiceAdminProxy.uuid failure - uuid field is null");
        }
    }

    protected ServiceAdmin getProxy() {
        if (this.localAdmin != null) {
            return this.localAdmin;
        }
        return this.serviceAdmin;
    }
}

