/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.servicecore;

import com.sun.jini.config.Config;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.id.Uuid;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventHandler;
import org.jini.rio.event.EventProducer;
import org.jini.rio.resources.servicecore.Service;
import org.jini.rio.watch.WatchDataSource;
import org.jini.rio.watch.WatchRegistry;

public abstract class ServiceProvider
implements Service {
    protected Hashtable eventTable = new Hashtable();
    protected volatile WatchRegistry watchRegistry;
    private Configuration config;
    private ProxyPreparer listenerPreparer = new BasicProxyPreparer();
    private static final String COMPONENT = "org.jini.rio.resources.servicecore";
    static final Logger logger = Logger.getLogger("org.jini.rio.resources.servicecore");

    public void setConfiguration(Configuration config) {
        this.config = config;
        if (config != null) {
            try {
                this.listenerPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"eventListenerPreparer", ProxyPreparer.class, (Object)this.listenerPreparer);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Getting eventListenerPreparer", e);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public EventRegistration register(EventDescriptor descriptor, RemoteEventListener listener, MarshalledObject handback, long duration) throws LeaseDeniedException, UnknownEventException, RemoteException {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is null");
        }
        if (descriptor.eventID == null) {
            throw new UnknownEventException("Event ID is null");
        }
        EventHandler eHandler = (EventHandler)this.eventTable.get(descriptor.eventID);
        if (eHandler == null) {
            throw new UnknownEventException("Unknown event ID " + descriptor.eventID);
        }
        listener = (RemoteEventListener)this.listenerPreparer.prepareProxy((Object)listener);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Register listener {0} for Event {1}", new Object[]{listener, descriptor});
        }
        return eHandler.register((EventProducer)this.getServiceProxy(), listener, handback, duration);
    }

    public abstract Object getAdmin();

    public abstract void destroy();

    public abstract Object getServiceProxy();

    public abstract Uuid getUuid();

    public WatchDataSource[] fetch() throws RemoteException {
        WatchDataSource[] wds = new WatchDataSource[]{};
        if (this.watchRegistry != null) {
            wds = this.watchRegistry.fetch();
        } else {
            logger.warning("WatchRegistry is null");
        }
        return wds;
    }

    public WatchDataSource[] fetch(String id) throws RemoteException {
        WatchDataSource[] wds = new WatchDataSource[]{};
        if (this.watchRegistry != null) {
            wds = this.watchRegistry.fetch(id);
        } else {
            logger.warning("WatchRegistry is null");
        }
        return wds;
    }

    public Hashtable getEventTable() {
        return this.eventTable;
    }

    public WatchRegistry getWatchRegistry() {
        return this.watchRegistry;
    }

    public void setWatchRegistry(WatchRegistry watchRegistry) {
        this.watchRegistry = watchRegistry;
    }
}

