/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaEntityResolver
implements EntityResolver {
    private ClassLoader classLoader;
    private static final Logger logger = Logger.getLogger("org.jini.rio.resources.util");

    public JavaEntityResolver() {
        Class<?> c = this.getClass();
        this.classLoader = c.getClassLoader();
    }

    public JavaEntityResolver(ClassLoader classLoader) {
        this();
        this.setClassLoader(classLoader);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (publicId != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Looking for public {0}, java:// for public is not yet implemented", new Object[]{publicId});
            }
            System.out.flush();
        }
        boolean isThrowing = false;
        if (systemId != null) {
            if (systemId.startsWith("java://")) {
                String target = systemId.substring(7);
                int paren = 0;
                paren = target.indexOf(40);
                if (paren > 2) {
                    int demarc = target.lastIndexOf(46, paren);
                    String classpart = target.substring(0, demarc);
                    Hashtable methodTable = this.getMethodParts(target.substring(demarc + 1));
                    LinkedList<GenericDeclaration> list = new LinkedList<GenericDeclaration>();
                    Class[] paramTypes = null;
                    Object[] paramArgs = null;
                    try {
                        Class<?> clazz = Class.forName(classpart, true, this.classLoader);
                        Method meth = null;
                        Object instance = null;
                        list.add(clazz);
                        int last = methodTable.size() - 1;
                        int i = 0;
                        Enumeration en = methodTable.keys();
                        while (en.hasMoreElements()) {
                            String key = (String)en.nextElement();
                            String[] paramparts = this.getParamParts((String)methodTable.get(key));
                            if (paramparts.length == 0) {
                                paramTypes = new Class[]{};
                                paramArgs = new Object[]{};
                            } else {
                                int j;
                                paramTypes = new Class[paramparts.length];
                                for (j = 0; j < paramparts.length; ++j) {
                                    paramTypes[j] = String.class;
                                }
                                paramArgs = new Object[paramparts.length];
                                for (j = 0; j < paramparts.length; ++j) {
                                    paramArgs[j] = paramparts[j];
                                }
                            }
                            String method = key;
                            meth = clazz.getMethod(method, paramTypes);
                            list.add(meth);
                            if (i < last) {
                                clazz = meth.getReturnType();
                                list.add(clazz);
                            }
                            ++i;
                        }
                        Iterator iter = list.iterator();
                        while (iter.hasNext()) {
                            try {
                                clazz = (Class<?>)iter.next();
                                meth = (Method)iter.next();
                                instance = clazz.newInstance();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            instance = meth.invoke(instance, paramArgs);
                        }
                        if (instance == null) {
                            isThrowing = true;
                            System.out.println("Target [" + target + "] unresolvable");
                            throw new SAXException("Target [" + target + "] unresolvable");
                        }
                        return new InputSource(new StringReader(instance.toString().trim()));
                    }
                    catch (Throwable th) {
                        if (isThrowing) {
                            throw (SAXException)th;
                        }
                        th.printStackTrace();
                        return null;
                    }
                }
                InputStream in = this.getClassLoader().getResourceAsStream(target);
                if (in != null) {
                    return new InputSource(in);
                }
                logger.log(Level.WARNING, "Failed to find in class path " + systemId);
                System.out.flush();
                return null;
            }
            return null;
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private Hashtable getMethodParts(String target) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            int index = 0;
            while (index < target.length()) {
                String part = target.substring(index, target.length());
                int ndx1 = part.indexOf(40);
                if (ndx1 == -1) {
                    return table;
                }
                String method = part.substring(0, ndx1);
                int ndx2 = part.indexOf(41);
                if (ndx2 - ndx1 > 1) {
                    String args = part.substring(ndx1 + 1, ndx2);
                    table.put(method, args);
                } else {
                    table.put(method, "");
                }
                if (!target.substring(index += ndx2 + 1, target.length()).startsWith(".")) continue;
                ++index;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return table;
    }

    private String[] getParamParts(String target) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(target, ",)");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            list.add(param);
        }
        return list.toArray(new String[list.size()]);
    }
}

