/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.util;

import java.io.File;

public class PropertyHelper {
    public static final String[] PARSETIME = new String[]{"${", "}"};
    public static final String[] RUNTIME = new String[]{"$[", "]"};

    public static String expandProperties(String arg, String[] delimeters) {
        if (arg == null) {
            throw new NullPointerException("arg is null");
        }
        if (delimeters == null) {
            throw new NullPointerException("delimiters is null");
        }
        if (delimeters.length < 2) {
            throw new IllegalArgumentException("delimiters bad size");
        }
        String start = delimeters[0];
        String end = delimeters[1];
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = arg.indexOf(start, s)) >= 0) {
            String str = arg.substring(e + start.length());
            int n = str.indexOf(end);
            if (n != -1) {
                result.append(arg.substring(s, e));
                String prop = str.substring(0, n);
                if (prop.equals("/")) {
                    result.append(File.separator);
                } else {
                    String value = System.getProperty(prop);
                    if (value == null) {
                        throw new IllegalArgumentException("property [" + prop + "] not declared");
                    }
                    result.append(value);
                }
                s = e + start.length() + prop.length() + end.length();
                continue;
            }
            result.append(start);
            s = e + start.length();
        }
        result.append(arg.substring(s));
        return result.toString();
    }
}

