/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class RioManifest {
    public static final Attributes.Name RIO_BUILD = new Attributes.Name("Rio-Build");
    private JarURLConnection uc = null;
    private JarInputStream jarIn = null;
    private Manifest manifest;

    public RioManifest(URL url) throws IOException {
        if (!url.getProtocol().equals("jar")) {
            url = new URL("jar:" + url.toExternalForm() + "!/");
        }
        this.uc = (JarURLConnection)url.openConnection();
        this.setManifest(this.uc.getManifest());
    }

    public RioManifest(InputStream in) throws IOException {
        this.jarIn = new JarInputStream(in);
        this.setManifest(this.jarIn.getManifest());
    }

    public RioManifest(Manifest manifest) {
        this.setManifest(manifest);
    }

    public void close() throws IOException {
        if (this.jarIn != null) {
            this.jarIn.close();
        }
    }

    public String getRioBuild() throws IOException {
        return this.getMainAttribute(RIO_BUILD);
    }

    public String getMainAttribute(String name) throws IOException {
        return this.getMainAttribute(new Attributes.Name(name));
    }

    public String getMainAttribute(Attributes.Name name) throws IOException {
        if (this.manifest == null) {
            throw new NullPointerException("there is no manifest");
        }
        Attributes attributes = this.manifest.getMainAttributes();
        if (attributes == null) {
            return null;
        }
        return (String)attributes.get(name);
    }

    public Attributes getEntry(String name) throws IOException {
        if (this.manifest == null) {
            throw new NullPointerException("there is no manifest");
        }
        return this.manifest.getAttributes(name);
    }

    public Attributes getMainAttributes() throws IOException {
        if (this.manifest == null) {
            throw new NullPointerException("there is no manifest");
        }
        return this.manifest.getMainAttributes();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }
}

