/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.util;

import com.gigaspaces.internal.io.BootIOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jini.rio.boot.TLSUtils;
import org.jini.rio.core.provision.SoftwareDownloadRecord;
import org.jini.rio.core.provision.SoftwareLoad;
import org.jini.rio.resources.util.StreamRedirector;

public class SoftwareLoadManager {
    private String installPath;
    private SoftwareLoad softwareLoad;
    private SoftwareDownloadRecord softwareRecord;
    private SoftwareDownloadRecord postInstallRecord;
    private List postInstallExtractList;

    public SoftwareLoadManager(String installPath, SoftwareLoad softwareLoad) {
        if (installPath == null) {
            throw new NullPointerException("installPath is null");
        }
        if (softwareLoad == null) {
            throw new NullPointerException("softwareLoad is null");
        }
        this.installPath = installPath;
        this.softwareLoad = softwareLoad;
        TLSUtils.enableHttpsClient();
    }

    public SoftwareDownloadRecord download() throws IOException {
        if (this.softwareRecord != null) {
            return this.softwareRecord;
        }
        SoftwareLoad.SoftwareDownloadAttributes downloadAttrs = this.softwareLoad.getSoftwareDownloadAttributes();
        return this.doDownload(downloadAttrs, false);
    }

    private SoftwareDownloadRecord doDownload(SoftwareLoad.SoftwareDownloadAttributes downloadAttrs, boolean postInstall) throws IOException {
        String installRoot = "";
        int extractedSize = 0;
        long extractTime = 0L;
        boolean unarchived = false;
        if (downloadAttrs == null) {
            throw new NullPointerException("downloadAttrs is null");
        }
        URL location = downloadAttrs.getLocation();
        String extension = downloadAttrs.getInstallRoot();
        boolean unarchive = downloadAttrs.unarchive();
        installRoot = extension.indexOf("/") != -1 ? extension.replace('/', File.separatorChar) : extension.replace('\\', File.separatorChar);
        File targetPath = new File(SoftwareLoadManager.makeFileName(this.installPath, installRoot));
        if (!targetPath.exists()) {
            targetPath.mkdirs();
            if (!targetPath.exists()) {
                throw new IOException("Failed to create : " + this.installPath);
            }
        }
        if (!targetPath.canWrite()) {
            throw new IOException("Can not write to : " + this.installPath);
        }
        String source = location.toExternalForm();
        int index = source.lastIndexOf("/");
        if (index == -1) {
            throw new IllegalArgumentException("Don't know how to install : " + source);
        }
        String software = source.substring(index + 1);
        String target = targetPath.getCanonicalPath();
        System.out.println("Installing software at " + target);
        File targetFile = new File(SoftwareLoadManager.makeFileName(target, software));
        long t0 = System.currentTimeMillis();
        URLConnection con = location.openConnection();
        int downloadedSize = this.writeFileFromInputStream(con.getInputStream(), targetFile);
        long t1 = System.currentTimeMillis();
        long downloadTime = t1 - t0;
        Date downloadDate = new Date();
        if (unarchive) {
            t0 = System.currentTimeMillis();
            Object[] results = this.extract(targetPath, targetFile);
            t1 = System.currentTimeMillis();
            extractedSize = (Integer)results[0];
            if (postInstall) {
                this.postInstallExtractList = (List)results[1];
            }
            extractTime = t1 - t0;
            unarchived = true;
        }
        this.softwareRecord = new SoftwareDownloadRecord(location, target, software, downloadDate, downloadedSize, extractedSize, unarchived, downloadTime, extractTime);
        return this.softwareRecord;
    }

    private int writeFileFromInputStream(InputStream newIn, File file) throws FileNotFoundException, IOException {
        int totalWrote = 0;
        InputStream in = newIn;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            int read = 0;
            byte[] buf = new byte[2048];
            while ((read = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, read);
                totalWrote += read;
            }
        }
        catch (FileNotFoundException e) {
            file.delete();
            throw e;
        }
        catch (IOException e) {
            file.delete();
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return totalWrote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] extract(File directory, File archive) throws IOException {
        int extractSize = 0;
        ArrayList<File> extractList = new ArrayList<File>();
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                File file;
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) {
                    file = new File(directory.getCanonicalPath() + File.separator + zipEntry.getName());
                    file.mkdirs();
                    continue;
                }
                file = new File(directory.getCanonicalPath() + File.separator + zipEntry.getName());
                extractList.add(file);
                String fullPath = file.getCanonicalPath();
                int index = fullPath.lastIndexOf(File.separatorChar);
                String installPath = fullPath.substring(0, index);
                File targetPath = new File(installPath);
                if (!targetPath.exists()) {
                    targetPath.mkdirs();
                    if (!targetPath.exists()) {
                        throw new IOException("Failed to create : " + installPath);
                    }
                }
                if (!targetPath.canWrite()) {
                    throw new IOException("Can not write to : " + installPath);
                }
                InputStream in = zipFile.getInputStream(zipEntry);
                extractSize += this.writeFileFromInputStream(in, file);
            }
        }
        return new Object[]{new Integer(extractSize), extractList};
    }

    public SoftwareDownloadRecord postInstall() throws IOException {
        if (this.softwareRecord == null) {
            throw new IllegalStateException("software has not been downloaded");
        }
        SoftwareLoad.PostInstallAttributes postInstall = this.softwareLoad.getPostInstallAttributes();
        if (postInstall == null) {
            return null;
        }
        String path = this.softwareRecord.getPath();
        try {
            String executionTarget;
            SoftwareLoad.SoftwareDownloadAttributes downloadAttrs = postInstall.getSoftwareDownloadAttributes();
            if (downloadAttrs != null) {
                this.postInstallRecord = this.doDownload(downloadAttrs, true);
                path = this.postInstallRecord.getPath();
            }
            if ((executionTarget = postInstall.getExecutionTarget()) != null) {
                int result;
                String cmd;
                block16: {
                    cmd = this.getCommandLine(SoftwareLoadManager.makeFileName(path, executionTarget));
                    if (System.getProperty("org.jini.rio.debug") != null) {
                        System.out.println("Executing : " + cmd);
                    }
                    Process process = Runtime.getRuntime().exec(cmd);
                    PrintStream stdout = null;
                    PrintStream stderr = null;
                    if (System.getProperty("org.jini.rio.debug") != null) {
                        stdout = System.out;
                        stderr = System.err;
                    }
                    new StreamRedirector(process.getInputStream(), stdout).start();
                    new StreamRedirector(process.getErrorStream(), stderr).start();
                    result = 0;
                    try {
                        result = process.waitFor();
                    }
                    catch (InterruptedException ie) {
                        if (System.getProperty("org.jini.rio.debug") == null) break block16;
                        System.out.println("post installation facility [" + cmd + "] interrupted");
                    }
                }
                if (result != 0) {
                    throw new RuntimeException("executing post installation facility [" + cmd + "] failed");
                }
            }
            if (postInstall.removeOnCompletion()) {
                if (this.postInstallRecord != null) {
                    SoftwareLoadManager.remove(new File(SoftwareLoadManager.makeFileName(this.postInstallRecord.getPath(), this.postInstallRecord.getName())));
                }
                if (this.postInstallExtractList != null) {
                    Iterator it = this.postInstallExtractList.iterator();
                    while (it.hasNext()) {
                        SoftwareLoadManager.remove((File)it.next());
                    }
                }
            }
        }
        catch (IOException e) {
            if (this.postInstallRecord != null) {
                SoftwareLoadManager.remove(this.postInstallRecord);
            }
            throw e;
        }
        return this.postInstallRecord;
    }

    private String getCommandLine(String arg) {
        String test;
        int ndx;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows") && (ndx = arg.indexOf(" ")) != -1) {
            arg = "\"" + arg + "\"";
        }
        if ((test = arg.toLowerCase()).endsWith(".jar") || test.endsWith(".jar\"")) {
            arg = "java -jar " + arg;
        }
        String cmd = "";
        cmd = osName.indexOf("nt") > -1 || osName.indexOf("windows 2000") > -1 || osName.indexOf("windows xp") > -1 ? "cmd.exe /C " + arg : (osName.indexOf("windows 9") > -1 ? "command.com /C " + arg : arg);
        return cmd;
    }

    public void remove() {
        if (this.softwareRecord == null) {
            throw new IllegalStateException("software has not been downloaded");
        }
        SoftwareLoadManager.remove(this.softwareRecord);
        if (this.postInstallRecord != null) {
            SoftwareLoadManager.remove(this.postInstallRecord);
        }
    }

    public static void remove(SoftwareDownloadRecord record) {
        if (record == null) {
            throw new NullPointerException("record is null");
        }
        File software = new File(SoftwareLoadManager.makeFileName(record.getPath(), record.getName()));
        if (!software.exists()) {
            System.err.println("Software recorded at [" + software.getAbsolutePath() + "] does not exist on the file system, removal aborted");
            return;
        }
        if (record.unarchived()) {
            try {
                ZipFile zipFile = new ZipFile(software);
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    File file = new File(record.getPath() + File.separator + zipEntry.getName());
                    SoftwareLoadManager.remove(file);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SoftwareLoadManager.remove(software);
            File softwareDirectory = new File(record.getPath());
            String[] list = softwareDirectory.list();
            if (list.length == 0 && !softwareDirectory.getName().equals("native")) {
                SoftwareLoadManager.remove(softwareDirectory);
            }
        } else {
            SoftwareLoadManager.remove(software);
        }
    }

    static void remove(File file) {
        if (file.isDirectory()) {
            File[] files = BootIOUtils.listFiles((File)file);
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    SoftwareLoadManager.remove(files[i]);
                    continue;
                }
                files[i].delete();
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public static String makeFileName(String root, String extension) {
        String name = null;
        name = root.endsWith(File.separator) ? root + extension : root + File.separator + extension;
        return name;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                System.out.println("Usage: org.jini.rio.qos.SoftwareLoadManager download-URL install-root");
                System.exit(-1);
            }
            String downloadFrom = args[0];
            String installPath = args[1];
            SoftwareLoad load = new SoftwareLoad(new SoftwareLoad.SoftwareDownloadAttributes(new URL(downloadFrom), "Test", true));
            SoftwareLoadManager slm = new SoftwareLoadManager(installPath, load);
            SoftwareDownloadRecord record = slm.download();
            System.out.println("Details");
            System.out.println("-------");
            System.out.println(record.toString());
            SoftwareLoadManager.remove(record);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

