/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.util;

import com.gigaspaces.time.SystemTime;

public class TimeUtil {
    public static String format(long duration) {
        long value = duration;
        long seconds = (value /= 1000L) % 60L;
        long minutes = (value /= 60L) % 60L;
        long hours = (value /= 60L) % 24L;
        long days = value / 24L;
        String result = "";
        result = days > 0L ? days + (days > 1L ? " days" : " day") + (hours > 0L ? ", " + hours + TimeUtil.getHoursText(hours) : "") + (minutes > 0L ? ", " + minutes + TimeUtil.getMinutesText(minutes) : "") + (seconds > 0L ? ", " + seconds + TimeUtil.getSecondsText(seconds) : "") : (hours > 0L ? hours + TimeUtil.getHoursText(hours) + (minutes > 0L ? ", " + minutes + TimeUtil.getMinutesText(minutes) : "") + (seconds > 0L ? ", " + seconds + TimeUtil.getSecondsText(seconds) : "") : (minutes > 0L ? minutes + TimeUtil.getMinutesText(minutes) + (seconds > 0L ? ", " + seconds + TimeUtil.getSecondsText(seconds) : "") : (seconds > 0L ? seconds + TimeUtil.getSecondsText(seconds) : (duration >= 0L && duration < 1000L ? duration + TimeUtil.getMillisecondsText(duration) : "0"))));
        return result;
    }

    private static String getHoursText(long hours) {
        if (hours == 0L) {
            return " hours";
        }
        return hours > 1L ? " hours" : " hour";
    }

    private static String getMinutesText(long minutes) {
        if (minutes == 0L) {
            return " minutes";
        }
        return minutes > 1L ? " minutes" : " minute";
    }

    private static String getSecondsText(long seconds) {
        if (seconds == 0L) {
            return " seconds";
        }
        return seconds > 1L ? " seconds" : " second";
    }

    private static String getMillisecondsText(long milliseconds) {
        if (milliseconds == 0L) {
            return " milliseconds";
        }
        return milliseconds > 1L ? " milliseconds" : " millisecond";
    }

    public static long computeLeaseRenewalTime(long leaseDuration) {
        long RENEW_RTT = 5000L;
        long now = SystemTime.timeMillis();
        long endTime = now + leaseDuration;
        long delta = endTime - now;
        delta = delta <= RENEW_RTT ? (delta /= 2L) : (delta <= RENEW_RTT * 2L ? RENEW_RTT : (delta <= RENEW_RTT * 8L ? (delta /= 2L) : (delta <= 604800000L ? (delta /= 8L) : (delta <= 1209600000L ? 86400000L : 259200000L))));
        return endTime - delta - now;
    }
}

