/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.util;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class XMLFileChooser {
    JFileChooser chooser;
    JFrame frame;

    public XMLFileChooser(JFrame frame, File path, String title) {
        this.frame = frame;
        this.chooser = path == null ? new JFileChooser() : new JFileChooser(path);
        this.chooser.setDialogType(0);
        this.chooser.setDialogTitle(title);
        this.chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return ".xml";
            }
        });
    }

    public String getName() {
        if (this.chooser.showOpenDialog(this.frame) == 0) {
            File file = this.chooser.getSelectedFile();
            return this.chooser.getName(file);
        }
        return null;
    }

    public File getFile() {
        if (this.chooser.showOpenDialog(this.frame) == 0) {
            return this.chooser.getSelectedFile();
        }
        return null;
    }

    public File getCurrentDirectory() {
        return this.chooser.getCurrentDirectory();
    }

    static class PropertyFilter
    implements FilenameFilter {
        String extension;

        public PropertyFilter() {
        }

        public PropertyFilter(String extension) {
            this();
            this.extension = extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }
    }
}

