/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.tools.webster;

import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.security.CodeSource;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.tools.webster.Webster;

public class InternalWebster {
    private static Logger logger = Logger.getLogger("org.jini.rio.tools.webster");

    public static int startWebster(String exportJar) throws IOException {
        String codebase;
        String parentPath = null;
        InetAddress ip = SystemInfo.singleton().network().getHost();
        String localIPAddress = ip.getHostAddress();
        CodeSource cs = InternalWebster.class.getProtectionDomain().getCodeSource();
        if (cs == null) {
            throw new RuntimeException("Cannot determine CodeSource");
        }
        String codebase2 = cs.getLocation().toExternalForm();
        File jar = new File(codebase2);
        URL parentURL = new URL(jar.getParent());
        File parent = new File(parentURL.getPath());
        parentPath = parent.getPath();
        String sMinThreads = System.getProperty("org.jini.rio.tools.webster.minThreads", "1");
        int minThreads = 1;
        try {
            minThreads = new Integer(sMinThreads);
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, "Bad Min Threads Number [" + sMinThreads + "], default to " + minThreads, e);
        }
        String sMaxThreads = System.getProperty("org.jini.rio.tools.webster.maxThreads", "10");
        int maxThreads = 10;
        try {
            maxThreads = new Integer(sMaxThreads);
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, "Bad Max Threads Number [" + sMaxThreads + "], default to " + maxThreads, e);
        }
        int port = new Webster(0, parentPath, null, minThreads, maxThreads).getPort();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Webster MinThreads=" + minThreads + ", MaxThreads=" + maxThreads);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Webster serving on port=" + port);
        }
        if ((codebase = System.getProperty("java.rmi.server.codebase")) == null) {
            codebase = "http://" + localIPAddress + ":" + port + "/" + exportJar;
            System.setProperty("java.rmi.server.codebase", codebase);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Setting java.rmi.server.codebase : " + codebase);
            }
        }
        return port;
    }

    public static void main(String[] args) {
        try {
            InternalWebster.startWebster("rio-dl.jar");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

