/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.rmi.RemoteException;
import java.util.Vector;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.Statistics;
import org.jini.rio.watch.WatchDataSource;

public class Accumulator {
    private Calculable[] calcs;
    private Statistics statistics = new Statistics();
    private WatchDataSource source;

    public Accumulator(WatchDataSource source) {
        this.source = source;
    }

    public Calculable[] getCalcs() {
        if (this.calcs == null) {
            return new Calculable[0];
        }
        Calculable[] c = new Calculable[this.calcs.length];
        System.arraycopy(this.calcs, 0, c, 0, this.calcs.length);
        return c;
    }

    private Vector getValues(Calculable[] calcs) {
        Vector<Double> vals = new Vector<Double>(calcs.length);
        for (int i = 0; i < calcs.length; ++i) {
            vals.add(new Double(calcs[i].getValue()));
        }
        return vals;
    }

    private Calculable[] getCalcs(int offset, int length) throws RemoteException {
        this.calcs = this.source.getCalculable(offset, length);
        return this.calcs;
    }

    public void reset() {
        this.statistics.clearAll();
    }

    public void init(int offset, int length) throws RemoteException {
        this.reset();
        this.statistics.setValues(this.getValues(this.getCalcs(offset, length)));
    }

    public int count() {
        return this.statistics.count();
    }

    public int count(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.count();
    }

    public double max() {
        return this.statistics.max();
    }

    public double max(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.max();
    }

    public double mean() {
        return this.statistics.mean();
    }

    public double mean(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.mean();
    }

    public double median() {
        return this.statistics.median();
    }

    public double median(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.median();
    }

    public double min() {
        return this.statistics.min();
    }

    public double min(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.min();
    }

    public double mode() {
        return this.statistics.mode();
    }

    public double mode(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.mode();
    }

    public int modeCount() {
        return this.statistics.modeOccurrenceCount();
    }

    public int modeCount(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.modeOccurrenceCount();
    }

    public double range() {
        return this.statistics.range();
    }

    public double range(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.range();
    }

    public double standardDeviation() {
        return this.statistics.standardDeviation();
    }

    public double standardDeviation(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.standardDeviation();
    }

    public double sum() {
        return this.statistics.sum();
    }

    public double sum(int offset, int range) throws RemoteException {
        this.init(offset, range);
        return this.statistics.sum();
    }

    public WatchDataSource getSource() {
        return this.source;
    }

    public void setSource(WatchDataSource source) {
        this.source = source;
    }
}

