/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.watch.CalculableViewable;
import org.jini.rio.watch.DefaultCalculableView;
import org.jini.rio.watch.WatchDataSource;
import org.jini.rio.watch.Watchable;

public class AccumulatorViewer
extends JPanel
implements TreeSelectionListener {
    static final long serialVersionUID = 1L;
    private Watchable service;
    private WatchDataSource[] watchDataSources;
    private String[] wdsIDs;
    private CalculableViewable defaultDataView;
    private CalculableViewable dataView;
    private JTree tree;
    private DefaultMutableTreeNode root;
    private JComponent graphPanel;
    private GridBagPanel slidersPanel;
    private JSlider startSl;
    private JSlider stopSl;
    private int startSliderValue;
    private int stopSliderValue;
    boolean paintFlag;
    private ClassLoader loader;
    private JSplitPane mainSplitPane;
    private Timer autoRefresh;
    ChangeListener sliderListener;

    public AccumulatorViewer(Object item) throws Exception {
        this.dataView = this.defaultDataView = new DefaultCalculableView();
        this.root = new DefaultMutableTreeNode("Watches");
        this.paintFlag = false;
        this.sliderListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider src = (JSlider)evt.getSource();
                int fps = src.getValue();
                if (src == AccumulatorViewer.this.startSl) {
                    if (AccumulatorViewer.this.stopSl.getValue() <= fps) {
                        AccumulatorViewer.this.stopSl.setValue(fps);
                    }
                } else if (AccumulatorViewer.this.startSl.getValue() >= fps) {
                    AccumulatorViewer.this.startSl.setValue(fps);
                }
                AccumulatorViewer.this.startSl.setToolTipText(String.valueOf(AccumulatorViewer.this.startSl.getValue()));
                AccumulatorViewer.this.stopSl.setToolTipText(String.valueOf(AccumulatorViewer.this.stopSl.getValue()));
                AccumulatorViewer.this.startSliderValue = AccumulatorViewer.this.startSl.getValue();
                AccumulatorViewer.this.stopSliderValue = AccumulatorViewer.this.stopSl.getValue();
                AccumulatorViewer.this.dataView.setStartValue(AccumulatorViewer.this.startSliderValue - 1);
                AccumulatorViewer.this.dataView.setStopValue(AccumulatorViewer.this.stopSliderValue - 1);
                if (!AccumulatorViewer.this.paintFlag) {
                    AccumulatorViewer.this.graphPanel.repaint();
                }
                if (src.getValueIsAdjusting()) {
                    return;
                }
            }
        };
        this.loader = this.getClass().getClassLoader();
        this.getAccessibleContext().setAccessibleName("Watchable Viewer");
        if (((ServiceItem)item).service instanceof Watchable) {
            this.setService((Watchable)((ServiceItem)item).service);
        }
        this.initComponents();
    }

    public Remote getService() {
        return this.service;
    }

    public void setService(Watchable service) throws RemoteException {
        this.service = service;
        if (this.service != null) {
            this.watchDataSources = this.service.fetch();
            if (this.watchDataSources == null) {
                return;
            }
            if (this.watchDataSources.length > 0) {
                int wdsNbr = this.watchDataSources.length;
                this.wdsIDs = new String[wdsNbr];
                for (int i = 0; i < this.watchDataSources.length; ++i) {
                    this.wdsIDs[i] = this.watchDataSources[i].getID();
                }
                this.setTreeWDSNodes(this.wdsIDs);
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setUI(this);
        this.graphPanel = this.createGraphPanel();
        JSplitPane topSplitPane = new JSplitPane(1, this.createTreePanel(), this.graphPanel);
        topSplitPane.setDividerSize(2);
        topSplitPane.setContinuousLayout(true);
        topSplitPane.setDividerLocation(100);
        this.mainSplitPane = new JSplitPane(0, topSplitPane, this.createSliders(0, 0));
        this.mainSplitPane.setDividerSize(2);
        this.mainSplitPane.setContinuousLayout(true);
        this.mainSplitPane.setDividerLocation(350);
        this.add("Center", this.mainSplitPane);
        this.autoRefresh = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AccumulatorViewer.this.runAccumulator();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    AccumulatorViewer.this.autoRefresh.stop();
                }
            }
        });
    }

    @Override
    public void removeNotify() {
        if (this.autoRefresh != null && this.autoRefresh.isRunning()) {
            this.autoRefresh.stop();
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.autoRefresh != null && this.isVisible() && !this.autoRefresh.isRunning()) {
            this.autoRefresh.start();
        }
    }

    @Override
    public void setVisible(boolean flag) {
        if (this.autoRefresh != null) {
            if (flag && !this.autoRefresh.isRunning()) {
                this.autoRefresh.start();
            } else if (this.autoRefresh.isRunning()) {
                this.autoRefresh.stop();
            }
        }
        super.setVisible(flag);
    }

    private void setUI(Component component) {
        try {
            UIManager.setLookAndFeel(UIManager.getLookAndFeel());
            UIManager.put("Label.foreground", Color.black);
            UIManager.put("TitledBorder.titleColor", Color.black);
            SwingUtilities.updateComponentTreeUI(component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JComponent createTreePanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        this.tree = new JTree(this.root);
        this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree.setBackground(new Color(202, 202, 202));
        this.tree.setForeground(Color.green);
        this.tree.setRowHeight(-1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setCellRenderer(new AVTreeCellRenderer());
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new BoxLayout(bPanel, 0));
        JButton refreshB = new JButton("Refresh");
        refreshB.setToolTipText("Refresh Watch Data Source Graph");
        refreshB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AccumulatorViewer.this.runAccumulator();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        JButton resetB = new JButton("Reset");
        resetB.setToolTipText("Reset Watches");
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AccumulatorViewer.this.getWatches();
                }
                catch (RemoteException re) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(null, "Cannot reset watches\nRemoteException: " + re.getLocalizedMessage(), "Reset Watch Remote Error", 0);
                }
            }
        });
        JButton clearB = new JButton("Clear");
        clearB.setToolTipText("Clear all entries in the WatchDataSource");
        clearB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccumulatorViewer.this.clearWatch();
            }
        });
        bPanel.add(refreshB);
        bPanel.add(resetB);
        bPanel.add(clearB);
        panel.add("Center", this.tree);
        panel.add("South", bPanel);
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(panel);
        return sp;
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        try {
            this.runAccumulator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getWatches() throws RemoteException {
        this.root.removeAllChildren();
        this.setService(this.service);
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.root);
        this.tree.repaint();
    }

    private void clearWatch() {
        int[] selRows = this.tree.getSelectionRows();
        if (selRows == null || selRows.length == 0 || selRows[0] == 0) {
            return;
        }
        int wdsIdx = selRows[0] - 1;
        try {
            this.watchDataSources[wdsIdx].clear();
            this.runAccumulator();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void runAccumulator() throws RemoteException {
        int[] selRows = this.tree.getSelectionRows();
        if (selRows == null || selRows.length == 0 || selRows[0] == 0) {
            return;
        }
        int wdsIdx = selRows[0] - 1;
        this.dataView = this.defaultDataView;
        String view = this.watchDataSources[wdsIdx].getView();
        if (view != null) {
            try {
                this.dataView = this.loadView(view);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dataView.setWatchDataSource(this.watchDataSources[wdsIdx]);
        this.startSliderValue = this.dataView.getOffset() + 1;
        this.stopSliderValue = this.dataView.getOffset() + this.dataView.getLength();
        if (this.stopSliderValue < this.startSliderValue) {
            this.stopSliderValue = this.startSliderValue;
        }
        JComponent comp = this.createSliders(this.startSliderValue, this.stopSliderValue);
        if (this.mainSplitPane != null) {
            int dividerLoc = this.mainSplitPane.getDividerLocation();
            this.mainSplitPane.setBottomComponent(comp);
            this.mainSplitPane.setDividerLocation(dividerLoc);
        }
        this.graphPanel.repaint();
    }

    private void setTreeWDSNodes(String[] wdsNames) {
        for (int i = 0; i < wdsNames.length; ++i) {
            this.root.add(new DefaultMutableTreeNode(wdsNames[i]));
        }
    }

    private JComponent createGraphPanel() {
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 8318364807269742510L;

            @Override
            public Color getBackground() {
                return Color.white;
            }

            @Override
            public void paint(Graphics g) {
                AccumulatorViewer.this.paintFlag = true;
                AccumulatorViewer.this.dataView.paint(g, this.getSize());
                AccumulatorViewer.this.paintFlag = false;
            }
        };
        panel.setDoubleBuffered(true);
        return panel;
    }

    private CalculableViewable loadView(String view) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> vuClass = this.loader.loadClass(view);
        return (CalculableViewable)vuClass.newInstance();
    }

    private JComponent createSliders(int start, int stop) {
        this.startSl = new JSlider(0, start, stop, start);
        this.stopSl = new JSlider(0, start, stop, stop);
        int majotTS = stop < 10 ? 1 : stop / 10;
        int minorTS = stop < 10 ? 1 : stop / 100;
        this.startSl.setPaintTicks(true);
        this.startSl.setPaintLabels(true);
        this.stopSl.setPaintTicks(true);
        this.stopSl.setPaintLabels(true);
        this.startSl.setMajorTickSpacing(majotTS);
        this.startSl.setMinorTickSpacing(minorTS);
        this.stopSl.setMajorTickSpacing(majotTS);
        this.stopSl.setMinorTickSpacing(minorTS);
        this.startSl.addChangeListener(this.sliderListener);
        this.stopSl.addChangeListener(this.sliderListener);
        if (this.slidersPanel != null) {
            this.remove(this.slidersPanel);
        }
        this.slidersPanel = new GridBagPanel();
        this.slidersPanel.setBorder(BorderFactory.createTitledBorder("Range"));
        this.slidersPanel.addLabeledComp("Start", this.startSl);
        this.slidersPanel.addLabeledComp("End", this.stopSl);
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(this.slidersPanel);
        this.invalidate();
        this.validate();
        return sp;
    }

    static class GridBagPanel
    extends JPanel {
        private static final long serialVersionUID = -6554968526461794658L;
        private GridBagLayout layout = new GridBagLayout();
        public GridBagConstraints constraints = new GridBagConstraints();

        public GridBagPanel() {
            this.setLayout(this.layout);
            this.constraints.fill = 2;
        }

        public void addLabeledComp(String labelText, Component comp) {
            this.constraints.weightx = 0.0;
            this.constraints.gridwidth = -1;
            this.layout.setConstraints(comp, this.constraints);
            super.add(new JLabel(labelText));
            this.constraints.weightx = 1.0;
            this.constraints.gridwidth = 0;
            this.layout.setConstraints(comp, this.constraints);
            super.add(comp);
        }
    }

    static class AVTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -1932801334209449510L;
        final Color SelectedBackgroundColor = Color.yellow;
        protected boolean selected;

        AVTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.selected = selected;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Color bColor = this.selected ? this.SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
            g.setColor(bColor);
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            super.paint(g);
        }
    }
}

