/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.ThresholdManager;

public class BoundedThresholdManager
extends ThresholdManager {
    private boolean thresholdCrossed = false;
    private static final int LowerThresholdCrossed = 1;
    private static final int UpperThresholdCrossed = 2;
    private int direction = 0;
    static Logger logger = Logger.getLogger("org.jini.rio.watch");

    @Override
    public boolean getThresholdCrossed() {
        return this.thresholdCrossed;
    }

    @Override
    public void checkThreshold(Calculable calculable) {
        ThresholdValues thresholdValues = this.getThresholdValues();
        double value = calculable.getValue();
        if (this.thresholdCrossed) {
            if (this.direction == 2) {
                if (value < thresholdValues.getCurrentHighThreshold()) {
                    this.thresholdCrossed = false;
                    this.direction = 0;
                    this.checkLowThresholdBreach(calculable);
                    if (!this.thresholdCrossed) {
                        thresholdValues.incThresholdClearedCount();
                        this.notifyListeners(calculable, 1);
                    }
                }
            } else if (this.direction == 1 && value > thresholdValues.getCurrentLowThreshold()) {
                this.thresholdCrossed = false;
                this.direction = 0;
                this.checkHighThresholdBreach(calculable);
                if (!this.thresholdCrossed) {
                    this.notifyListeners(calculable, 1);
                    thresholdValues.incThresholdClearedCount();
                }
            }
        } else {
            this.checkHighThresholdBreach(calculable);
            this.checkLowThresholdBreach(calculable);
        }
    }

    private void checkHighThresholdBreach(Calculable calculable) {
        double value = calculable.getValue();
        if (value > this.thresholdValues.getCurrentHighThreshold()) {
            this.thresholdCrossed = true;
            this.direction = 2;
            this.thresholdValues.incThresholdBreachedCount();
            this.notifyListeners(calculable, 0);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "[" + calculable.getId() + "] Check High Threshold breach, value=" + value + ", high threshold=" + this.thresholdValues.getCurrentHighThreshold());
        }
    }

    private void checkLowThresholdBreach(Calculable calculable) {
        double value = calculable.getValue();
        if (value < this.thresholdValues.getCurrentLowThreshold()) {
            this.thresholdCrossed = true;
            this.direction = 1;
            this.thresholdValues.incThresholdBreachedCount();
            this.notifyListeners(calculable, 0);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "[" + calculable.getId() + "] Check Low Threshold breach, value=" + value + ", low threshold=" + this.thresholdValues.getCurrentLowThreshold());
        }
    }
}

