/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import net.jini.config.Configuration;
import org.jini.rio.watch.Archivable;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.CounterWatchMBean;
import org.jini.rio.watch.ThresholdWatch;
import org.jini.rio.watch.WatchDataSource;

public class CounterWatch
extends ThresholdWatch
implements CounterWatchMBean {
    public static final String VIEW = "org.jini.rio.watch.CounterCalculableView";
    private long counter;

    public CounterWatch(String id, Configuration config) {
        super(id, null, config);
        this.setView(VIEW);
    }

    public CounterWatch(String id, Archivable archivable, Configuration config) {
        super(id, archivable, config);
        this.setView(VIEW);
    }

    public CounterWatch(WatchDataSource watchDataSource, String id) {
        super(watchDataSource, id);
        this.setView(VIEW);
    }

    @Override
    public long getCounter() {
        return this.counter;
    }

    @Override
    public void setCounter(long counter) {
        this.counter = counter;
        this.addWatchRecord(new Calculable(this.id, (double)counter, System.currentTimeMillis()));
    }

    @Override
    public void increment() {
        this.setCounter(this.counter + 1L);
    }

    @Override
    public void increment(long value) {
        this.setCounter(this.counter + value);
    }

    @Override
    public void decrement() {
        this.setCounter(this.counter - 1L);
    }

    @Override
    public void decrement(long value) {
        this.setCounter(this.counter - value);
    }
}

